package com.bcxin.tenant.bcx.domains.services;

import com.bcxin.tenant.bcx.domains.entities.MetaModuleEntity;
import com.bcxin.tenant.bcx.domains.repositories.criterias.MetaModuleSearchCriteria;
import com.bcxin.tenant.bcx.domains.services.commands.DeleteDataCommand;
import com.bcxin.tenant.bcx.domains.services.commands.modules.BatchLogicalDeleteModuleCommand;
import com.bcxin.tenant.bcx.domains.services.commands.modules.CreateMetaModuleCommand;
import com.bcxin.tenant.bcx.domains.services.commands.modules.LogicalDeleteModuleCommand;
import com.bcxin.tenant.bcx.domains.services.commands.modules.UpdateMetaModuleCommand;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;

/**
 * 模块元数据服务接口
 */
public interface MetaModuleService {
    void dispatch(CreateMetaModuleCommand command);

    void dispatch(UpdateMetaModuleCommand command);

    void dispatch(DeleteDataCommand command);

    /**
     * 逻辑删除模块
     */
    void dispatch(LogicalDeleteModuleCommand command);

    /**
     * 批量逻辑删除模块
     */
    void dispatch(BatchLogicalDeleteModuleCommand command);

    EntityCollection<MetaModuleEntity> search(MetaModuleSearchCriteria criteria);

    MetaModuleEntity getById(String id);
}
