package com.bcxin.tenant.bcx.domains.repositories;

import com.bcxin.tenant.bcx.domains.criterias.DynamicPageDataCriteria;
import com.bcxin.tenant.bcx.domains.entities.DynamicPageDataEntity;
import com.bcxin.tenant.bcx.infrastructures.EntityCollection;
import com.bcxin.tenant.bcx.infrastructures.enums.DoActionType;
import com.bcxin.tenant.bcx.infrastructures.repositories.RepositoryBase;

import java.util.Collection;

public interface DynamicPageDataRepository extends RepositoryBase<DynamicPageDataEntity> {
    EntityCollection<DynamicPageDataEntity> search(DynamicPageDataCriteria criteria);

    DynamicPageDataEntity getById(String pageId, String id);

    void delete(String pageId, String id);

    void batchInsert(Collection<DynamicPageDataEntity> entities);

    void doAction(DynamicPageDataEntity entity, DoActionType actionType);
}
