package com.bcxin.tenant.bcx.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.bcx.infrastructures.entities.Aggregate;
import com.bcxin.tenant.bcx.infrastructures.entities.EntityAbstract;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;

@Data
@EqualsAndHashCode(callSuper = false)
@TableName(value = "meta_menus",autoResultMap = true)
public class MetaMenuEntity extends EntityAbstract implements Aggregate {
    @TableId(value = "id")
    private String id;

    @TableField(value = "name")
    private String name;

    /**
     * 页面Id
     */
    @TableField(value = "page_id")
    private String pageId;

    /**
     * 上级菜单Id
     */
    @TableField(value = "parent_id")
    private String parentId;

    /**
     * 菜单层级树Id; 用于快速定位菜单
     */
    @TableField(value = "index_tree_id")
    private String indexTreeId;

    /**
     * 页面的slug; 冗余字段; MetaPageEntity中的slug不允许更改
     */
    @TableField(value = "slug")
    private String slug;

    /**
     * 适配设备; 异或类型
     */
    @TableField(value = "medium_type", jdbcType = JdbcType.TINYINT, javaType = true)
    private int mediumType;

    @TableField(value = "project_id")
    private String projectId;

    @TableField(value = "last_updated_time")
    private Timestamp lastUpdatedTime;

    @TableField(value = "created_time")
    private Timestamp createdTime;
}
