package com.bcxin.backend.domain.models;

import com.bcxin.runtime.domain.messages.enums.ProcessesStatus;
import com.bcxin.saas.core.IAggregate;
import com.bcxin.saas.core.enums.MessageType;
import com.bcxin.saas.core.enums.ReceiverType;
import com.bcxin.saas.core.models.EntityBase;
import lombok.Data;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;

/**
 * 站内消息
 */
@Data
@Entity
@Table(name = "shared_messages")
public class MessageEntity extends EntityBase<String> implements IAggregate {

    /**
     *
     */
    private static final long serialVersionUID = -4836070850643712525L;

    @Id
    @Column(
            length = 50
    )
    private String id;
    @Column(
            name = "title",
            length = 500
    )
    private String title;
    @Column(
            name = "content",
            nullable = false,
            length = 5000
    )
    private String content;
    @Column(
            name = "parameter_json",
            length = 2000
    )
    private String parameterJson;
    @Column(
            name = "sender_id",
            nullable = false,
            length = 100
    )
    private String senderId;
    @Column(
            name = "receiver",
            nullable = false,
            length = 100
    )
    private String receiver;
    @Column(
            name = "message_type",
            nullable = false
    )
    private MessageType messageType;
    @Column(
            name = "receiver_type",
            nullable = false
    )
    private ReceiverType receiverType;
    @Column(
            name = "status",
            nullable = false
    )
    private ProcessesStatus status;
    @Column(
            name = "created_time",
            nullable = false
    )
    private Timestamp createdTime;
    @Column(
            name = "last_processed_time"
    )
    private Timestamp lastProcessedTime;
    @Column(
            name = "business_number",
            length = 500
    )
    private String businessNumber;
    @Column(
            name = "unique_id",
            nullable = false,
            length = 200
    )
    private String uniqueId;

    public MessageEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setStatus(ProcessesStatus.Init);
    }

    public void makeStatus(boolean isSuccess) {
        this.setStatus(isSuccess ? ProcessesStatus.Done : ProcessesStatus.Error);
        this.setLastProcessedTime(Timestamp.from(Instant.now()));
    }

}
