package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "RollCallProgressStatusResponse",title = "调度的进度")
@Getter
public class RollCallProgressStatusResponse extends ResponseAbstract {
    @Schema(name = "rollCallId", title = "点名的Id")
    private final String rollCallId;
    @Schema(name = "countOfMembers", title = "被点名的总人数")
    private final int countOfMembers;
    @Schema(name = "countOfProcessed", title = "有结果的点名人数")
    private final int countOfProcessed;

    @Schema(name = "isCompleted", title = "点名是否已完成")
    public boolean isCompleted() {
        return this.getCountOfProcessed() >= this.getCountOfMembers();
    }

    public RollCallProgressStatusResponse(Long rollCallId,int countOfMembers, int countOfProcessed) {
        this.countOfMembers = countOfMembers;
        this.countOfProcessed = countOfProcessed;
        this.rollCallId = String.valueOf(rollCallId);
    }

    public static RollCallProgressStatusResponse create(Long rollCallId,int countOfMembers, int countOfProcessed) {
        return new RollCallProgressStatusResponse(rollCallId,countOfMembers, countOfProcessed);
    }
}
