package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;

@Schema(name = "MyDispatchLogRecordResponse",title = "我的点名记录")
@Getter
public class MyDispatchLogRecordResponse extends ResponseAbstract {
    private final String id;
    @Schema(name = "callerName", title = "调度方（人）")
    private final String callerName;
    @Schema(name = "callerCompanyName", title = "调度方")
    private final String callerCompanyName;
    @Schema(name = "communicatedTypeLabel", title = "调度方式")
    private final String communicatedTypeLabel;
    @Schema(name = "beginTime", title = "被调度开始时间")
    private final String beginTime;
    @Schema(name = "endTime", title = "被调度结束时间")
    private final String endTime;
    @Schema(name = "dispatchTime", title = "调度时长")
    private final int dispatchTime;
    @Schema(name = "createdTime", title = "标题上的日期")
    private final String createdTime;

    public MyDispatchLogRecordResponse(
            String id,
            String callerName, String callerCompanyName,
            CommunicatedType communicatedType, Timestamp beginTime, Timestamp endTime,
            int dispatchTime, Timestamp createdTime) {
        this.id = id;
        this.callerName = callerName;
        this.callerCompanyName = callerCompanyName;
        this.communicatedTypeLabel = communicatedType.getTypeName();


        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (beginTime != null) {
            this.beginTime = timeFormat.format(beginTime);
        } else {
            this.beginTime = "-";
        }
        if (endTime != null) {
            this.endTime = timeFormat.format(endTime);
        } else {
            this.endTime = "-";
        }

        this.dispatchTime = dispatchTime;

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy年MM月dd日");
        this.createdTime = dateFormat.format(createdTime);
    }

    public static MyDispatchLogRecordResponse create(String id,
                                                     String callerName, String callerCompanyName,
                                                     CommunicatedType communicatedType,
                                                     Timestamp beginTime, Timestamp endTime,
                                                     int dispatchTime, Timestamp createdTime) {
        return new MyDispatchLogRecordResponse(id, callerName, callerCompanyName, communicatedType, beginTime, endTime, dispatchTime, createdTime);
    }
}
