package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.jdks.requests.ExamSiteRoomSearchRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "ExamSiteRoomOverviewResponse",title = "考场信息")
@Getter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ExamSiteRoomOverviewResponse extends ResponseAbstract {
    @Schema(name = "id", title = "考场Id")
    private final String id;
    @Schema(name = "name", title = "考场名称")
    private final String name;
    @Schema(name = "examSiteName", title = "考试点")
    private final String examSiteName;
    @Schema(name = "companyName", title = "所在公司")
    private final String companyName;

    @Schema(name = "latitude", title = "考场所在y轴坐标")
    private final Double latitude;

    @Schema(name = "longitude", title = "考场所在x轴坐标")
    private final Double longitude;

    @Schema(name = "status", title = "考场状态: true=启用; false=禁用")
    private final boolean status;

    @Schema(name = "hasVideo", title = "是否含有视频监控; 有的话, 跳转到视频监控的页面")
    private final boolean hasVideo;

    public ExamSiteRoomOverviewResponse(
            ExamSiteRoomSearchRequest.SearchModel searchModel,
            String id, String name,
                                        String examSiteName, String companyName,
                                        Double latitude,Double longitude,
                                        boolean status,
            Boolean hasVideo) {
        this.id = id;
        this.longitude = longitude;
        this.latitude = latitude;
        this.status = status;

        /**
         * 针对安保资源; 我们只显示这些
         */
        if (searchModel == ExamSiteRoomSearchRequest.SearchModel.SecurityResource) {
            this.name = null;
            this.examSiteName = null;
            this.companyName = null;
        } else {
            this.name = name;
            this.examSiteName = examSiteName;
            this.companyName = companyName;
        }

        this.hasVideo = hasVideo == null ? false : hasVideo.booleanValue();
    }

    public static ExamSiteRoomOverviewResponse create(
            ExamSiteRoomSearchRequest.SearchModel searchModel,
            String id,
                                                      String name, String examSiteName, String companyName,
                                                      Double latitude,Double longitude,
                                                      Boolean status,
            Boolean hasVideo) {
        return new ExamSiteRoomOverviewResponse(searchModel, id, name, examSiteName, companyName, latitude, longitude, status,hasVideo);
    }
}
