package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ExamType;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Schema(name = "ExamSiteRoomOverviewResponse",title = "考场信息")
@Getter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ExamSiteRoomDetailResponse  extends ResponseAbstract {
    @Schema(name = "id", title = "考场Id")
    private final String id;
    @Schema(name = "name", title = "考场名称")
    private final String name;
    @Schema(name = "examSiteName", title = "考试点")
    private final String examSiteName;

    @Schema(name = "examSiteId", title = "考试点Id")
    private final String examSiteId;

    @Schema(name = "companyName", title = "所在公司")
    private final String companyName;
    @Schema(name = "organizationId", title = "组织Id")
    private final String organizationId;
    @Schema(name = "countOfTeachers", title = "监考老师数量")
    private final int countOfTeachers;
    @Schema(name = "examType", title = "考试类型")
    private final String examType;
    @Schema(name = "examTimeScope", title = "当前考试时间")
    private final String examTimeScope;

    @Schema(name = "examId", title = "当前考试Id")
    private final String examId;
    @Schema(name = "examName", title = "当前考试名称")
    private final String examName;

    @Schema(name = "capacityOfPerson", title = "容纳的人员数量")
    private final int capacityOfPerson;

    @Schema(name = "scopeRange", title = "有效范围")
    private final String scopeRange;

    @Schema(name = "latitude", title = "考场所在y轴坐标")
    private final Double latitude;

    @Schema(name = "longitude", title = "考场所在x轴坐标")
    private final Double longitude;

    @Schema(name = "hasVideo", title = "是否含有视频监控; 有的话, 跳转到视频监控的页面")
    private final boolean hasVideo;

    public ExamSiteRoomDetailResponse(String id, String name,
                                      String examSiteId,
                                      String examSiteName,
                                      String companyName, String organizationId,
                                      int countOfTeachers, ExamType examType,
                                      LocalDateTime examBeginTime,
                                      LocalDateTime examEndTime,
                                      String examId,
                                      String examName,
                                      int capacityOfPerson, String scopeRange,
                                      Double latitude,
                                      Double longitude,
                                      Boolean hasVideo) {
        this.id = id;
        this.name = name;
        this.examSiteId = examSiteId;
        this.examSiteName = examSiteName;
        this.companyName = companyName;
        this.organizationId = organizationId;
        this.countOfTeachers = countOfTeachers;
        if (examType == null) {
            this.examType = "";
        } else {
            this.examType = examType.getTypeName();
        }
        if (examBeginTime != null && examEndTime != null) {
            DateTimeFormatter fromTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
            DateTimeFormatter endTimeFormat = DateTimeFormatter.ofPattern("HH:mm");
            this.examTimeScope = String.format(
                    "%s - %s",
                    examBeginTime.format(fromTimeFormat),
                    examEndTime.format(endTimeFormat)
            );
        } else {
            this.examTimeScope = "";
        }

        this.examName = examName;
        this.examId = examId;

        this.capacityOfPerson = capacityOfPerson;
        this.scopeRange = scopeRange;
        this.longitude = longitude;
        this.latitude = latitude;
        this.hasVideo = hasVideo == null ? false : hasVideo.booleanValue();
    }

    public static ExamSiteRoomDetailResponse create(String id, String name,
                                                    String examSiteId,
                                                    String examSiteName,
                                                    String companyName, String organizationId,
                                                    int countOfTeachers, ExamType examType,
                                                    LocalDateTime examBeginTime,
                                                    LocalDateTime examEndTime,
                                                    String examId,
                                                    String examName,
                                                    int capacityOfPerson, String scopeRange,
                                      Double latitude,
                                                    Double longitude,
                                                    Boolean hasVideo) {
        return new ExamSiteRoomDetailResponse(
                id, name, examSiteId,examSiteName, companyName, organizationId, countOfTeachers,
                examType, examBeginTime,examEndTime,examId, examName,
                capacityOfPerson, scopeRange,latitude,longitude,hasVideo);
    }
}
