package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;

@Schema(name = "DispatchLogDetailSearchResponse",title = "DispatchLogDetailSearchResponse 调度日志详情")
@Getter
public class DispatchLogDetailSearchResponse extends ResponseAbstract {
    @Schema(name = "id", title = "通讯详情")
    private final String id;
    @Schema(name = "calledUserName", title = "被调度成员")
    private final String calledUserName;
    @Schema(name = "calledDeviceNo", title = "账号")
    private final String calledDeviceNo;
    @Schema(name = "beginTime", title = "被调度开始时间")
    private String beginTime;
    @Schema(name = "endTime", title = "被调度结束时间")
    private final String endTime;
    @Schema(name = "communicatedType", title = "调度类型")
    private final String communicatedType;
    @Schema(name = "dispatchTimeInMinutes", title = "调度时间")
    private final int dispatchTimeInMinutes;
    @Schema(name = "points", title = "消耗联动值")
    private final int points;
    @Schema(name = "calledCompany",title = "所属公司")
    private final String calledCompany;

    public DispatchLogDetailSearchResponse(Long id, String calledUserName, String calledDeviceNo,
                                           Timestamp beginTime, Timestamp endTime,
                                           CommunicatedType communicatedType, int dispatchTimeInMinutes,
                                           int points,String calledCompany) {
        this.id = String.valueOf(id);
        this.calledUserName = calledUserName;
        this.calledDeviceNo = calledDeviceNo;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if(beginTime != null) {
            this.beginTime = dateFormat.format(beginTime);
        }
        if(endTime == null){
            this.endTime = "未接听";
            this.beginTime = "未接听";
        }else{
            this.endTime = dateFormat.format(endTime);
        }
        this.communicatedType = communicatedType == CommunicatedType.Video ? "视频" : (communicatedType == CommunicatedType.Audio ? "音频" : "其他");
        this.dispatchTimeInMinutes = dispatchTimeInMinutes;
        this.points = points;
        this.calledCompany = calledCompany;
    }

    public static DispatchLogDetailSearchResponse create(Long id, String calledUserName, String calledDeviceNo,
                                                         Timestamp beginTime, Timestamp endTime,
                                                         CommunicatedType communicatedType, int dispatchTimeInMinutes,
                                                         int points,String calledCompany) {
        return new DispatchLogDetailSearchResponse(id, calledUserName, calledDeviceNo, beginTime, endTime, communicatedType, dispatchTimeInMinutes, points,calledCompany);
    }
}
