package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import java.util.Collection;

@Schema(name = "CreateRoomWriterRpcResponse",title = "CreateRoomWriterRpcResponse 调度房间的房间信息")
@Getter
public class CreateRoomWriterRpcResponse extends ResponseAbstract {
    @Schema(name = "id", title = "作为音视频的房间号")
    private final long id;


    @Schema(name = "roomUsers", title = "被调度的人员列表")
    private final Collection<RoomUserResponse> roomUsers;

    public CreateRoomWriterRpcResponse(Long id,
                                       Collection<RoomUserResponse> roomUsers) {
        this.id = id;
        this.roomUsers = roomUsers;
    }

    public static CreateRoomWriterRpcResponse create(Long roomNo,
                                                     Collection<RoomUserResponse> roomUsers) {
        return new CreateRoomWriterRpcResponse(roomNo,roomUsers);
    }

    @Getter
    public static class RoomUserResponse extends ResponseAbstract {
        @Schema(name = "employeeId", title = "保安员的Id")
        private final String employeeId;
        @Schema(name = "organizationId", title = "企业Id")
        private final String organizationId;
        @Schema(name = "tencentUserId", title = "音视频Id")
        private final String tencentUserId;
        @Schema(name = "securityStationId", title = "驻勤点Id")
        private final String securityStationId;
        @Schema(name = "superviseDepartId", title = "监管归属Id")
        private final String superviseDepartId;
        @Schema(name = "sponsor", title = "是否为调度发起人")
        private final boolean isSponsor;

        @Schema(name = "cid", title = "最新的cid")
        private final String cid;

        @Schema(name = "points", title = "所在企业的联动值")
        private final long points;

        @Schema(name = "dispatchable", title = "该值为true的时候, 该企业的保安人员才可以被调度; 为false的时候, 该企业的保安人员不可被调度")
        private final boolean dispatchable;

        public RoomUserResponse(String employeeId, String organizationId, String tencentUserId, String securityStationId,
                                String cid,
                                String superviseDepartId, boolean isSponsor, long points, boolean dispatchable) {
            this.employeeId = employeeId;
            this.organizationId = organizationId;
            this.tencentUserId = tencentUserId;
            this.securityStationId = securityStationId;
            this.superviseDepartId = superviseDepartId;
            this.isSponsor = isSponsor;
            this.points = points;
            this.dispatchable = dispatchable;
            this.cid = cid;
        }

        public static RoomUserResponse create(String employeeId, String organizationId, String tencentUserId, String securityStationId,
                                              String cid,
                                              String superviseDepartId, boolean isSponsor, long points, boolean dispatchable) {
            return new RoomUserResponse(employeeId, organizationId, tencentUserId, securityStationId, cid, superviseDepartId,
                    isSponsor, points, dispatchable);
        }
    }
}
