package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import lombok.Getter;

@Getter
public class CreateRollCallResponse extends ResponseAbstract {
    private final String rollCallId;
    private final int countOfRollCallPerson;

    public CreateRollCallResponse(Long rollCallId, int countOfRollCallPerson) {
        this.rollCallId = String.valueOf(rollCallId);
        this.countOfRollCallPerson = countOfRollCallPerson;
    }

    public static CreateRollCallResponse create(Long rollCallId, int countOfRollCallPerson) {
        return new CreateRollCallResponse(rollCallId, countOfRollCallPerson);
    }
}
