package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "AttendanceDetailReaderResponse",title = "AttendanceDetailReaderResponse 签到详情信息")
@Getter
public class AttendanceDetailReaderResponse extends ResponseAbstract {
    @Schema(name = "createdTime", title = "签到时间")
    private final String createdTime;
    @Schema(name = "recordStatus", title = "签到状态")
    private final String recordStatus;
    @Schema(name = "referenceType", title = "签到类型")
    private final String referenceType;
    @Schema(name = "note", title = "备注")
    private final String note;
    @Schema(name = "address", title = "签到地址")
    private final String address;

    public AttendanceDetailReaderResponse(String createdTime, String recordStatus, String referenceType, String note, String address) {
        this.createdTime = createdTime;
        this.recordStatus = recordStatus;
        this.referenceType = referenceType;
        this.note = note;
        this.address = address;
    }


    public static AttendanceDetailReaderResponse create(String createdTime, String recordStatus, String referenceType, String note, String address) {
        return new AttendanceDetailReaderResponse( createdTime, recordStatus, referenceType, note, address);
    }
}
