package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.DispatchDataType;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import lombok.Data;
import lombok.Getter;

import java.util.Collection;
import java.util.Map;

@Data
public class SyncParameterWrapperRequest extends RequestAbstract {
    private DispatchDataType dataType;
    private Collection<String> ids;
    private Object additionalParameter;
    private boolean autoUpdateExpired;

    public static SyncParameterWrapperRequest create(DispatchDataType dataType,
                                                     Collection<String> ids,
                                                     Object additionalParameter) {
        SyncParameterWrapperRequest request = new SyncParameterWrapperRequest();
        request.setDataType(dataType);
        request.setIds(ids);
        request.setAdditionalParameter(additionalParameter);

        return request;
    }

    public static SyncParameterWrapperRequest create(DispatchDataType dataType,
                                                     Collection<String> ids) {
        return create(dataType, ids, null);
    }

    public void assignFromAutoExpiredCheck() {
        this.setAutoUpdateExpired(true);
    }


    @Getter
    public static class SyncHardwareDeviceDTO {

        private final String fieldValueSql;

        public SyncHardwareDeviceDTO(Map<String, String> deviceUidMap) {
            StringBuilder sb = new StringBuilder();

            if (deviceUidMap==null || deviceUidMap.isEmpty()) {
                this.fieldValueSql = "null";
            } else {
                sb.append("(case x.id");
                deviceUidMap.forEach((key, value) -> {
                    sb.append(String.format(" when '%s' then %s ", key, !StringUtil.isEmpty(value) ? String.format("'%s'", value) : value));
                });
                sb.append("end)");

                this.fieldValueSql = sb.toString();
            }
        }

        public static SyncHardwareDeviceDTO create(Map<String, String> deviceUidMap) {
            return new SyncHardwareDeviceDTO(deviceUidMap);
        }
    }
}
