package com.bcxin.tenant.open.jdks.requests;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;
import java.util.Date;

@Schema(name = "SecurityStationRailMessageSearchRequest",title = "SecurityStationRailMessageSearchRequest 搜索电子围栏告警信息高级筛选条件")
@Data
public class SecurityStationRailMessageSearchRequest extends SearchDeskRequestAbstract {
    @Schema(name = "employeeName", title = "姓名")
    private String employeeName;
    @Schema(name = "companyName", title = "企业名称")
    private String companyName;
    @Schema(name = "railReferenceName",title = "驻勤点、岗点名称")
    private String railReferenceName;
    @Schema(name = "projectName",title = "项目名称")
    private String projectName;

    @Schema(name = "superviseDepartIds", title = "监管机构ID")
    private Collection<String> superviseDepartIds;
    @Schema(name = "eventStartDate", title = "事件日期 开始 yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date eventStartDate;

    @Schema(name = "eventEndDate", title = "事件日期 结束 yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date eventEndDate;
    @Schema(name = "employeeIdCardNo", title = "身份证号")
    private String employeeIdCardNo;
}
