package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.TRTCActionType;
import lombok.Getter;

import java.util.Collection;

@Getter
public class RollCallBatchEmployeeRoomActionRequest extends RequestAbstract{
    private final Collection<RollCallBatchEmployeeRoomActionRequest.DispatchRollCallReplyRequest> data;


    public RollCallBatchEmployeeRoomActionRequest(Collection<RollCallBatchEmployeeRoomActionRequest.DispatchRollCallReplyRequest> data) {
        this.data = data;
    }

    public static RollCallBatchEmployeeRoomActionRequest create(Collection<RollCallBatchEmployeeRoomActionRequest.DispatchRollCallReplyRequest> data) {
        return new RollCallBatchEmployeeRoomActionRequest(data);
    }

    @Getter
    public static class DispatchRollCallReplyRequest extends RequestAbstract {
        private final Long id;
        private final TRTCActionType actionType;
        private final Collection<String> employeeIds;

        public DispatchRollCallReplyRequest(Long id, TRTCActionType actionType, Collection<String> employeeIds) {
            this.id = id;
            this.actionType = actionType;
            this.employeeIds = employeeIds;
        }

        public static DispatchRollCallReplyRequest create(Long id, TRTCActionType actionType, Collection<String> employeeIds) {
            DispatchRollCallReplyRequest rt = new DispatchRollCallReplyRequest(id, actionType, employeeIds);

            return rt;
        }
    }
}
