package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.PoliceEventCategory;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventLevel;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventStatus;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.sql.Timestamp;
import java.util.Collection;

@Schema(name = "PoliceIncidentsSearchRequest",title = "PoliceIncidentsSearchRequest 高级筛选条件")
@Data
public class PoliceIncidentsSearchRequest extends SearchDeskRequestAbstract {
    @Schema(name = "name", title = "事件标题")
    private String name;
    @Schema(name = "status", title = "处理状态：None 待处理，Pending 处理中，Over 已处理")
    private PoliceEventStatus status;
    @Schema(name = "reason", title = "事件起因")
    private String reason;

    @Schema(name = "type", title = "事件类型")
    private Integer type;

    @Schema(name = "categories", title = "事件类别列表; Sos传递Sos")
    private PoliceEventCategory category;

    @Schema(name = "level", title = "事件级别：Comon 一般，More 较大，Great 重大，Greats 特别重大")
    private PoliceEventLevel level;

    @Schema(name = "policeEventLevel", title = "事件级别：Comon 一般，More 较大，Great 重大，Greats 特别重大")
    private PoliceEventLevel policeEventLevel;

    @Schema(name = "processedUserName", title = "处理人(公安)姓名")
    private String processedUserName;
    @Schema(name = "empName", title = "人员姓名")
    private String empName;
    @Schema(name = "empIdNumber", title = "人员身份证")
    private String empIdNumber;

    @Schema(name = "contact", title = "联系电话")
    private String contact;

    @Schema(name = "processedStarTime", title = "处理时间 开始 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Timestamp processedStarTime;

    @Schema(name = "processedEndTime", title = "处理时间 结束 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Timestamp processedEndTime;

    @Schema(name = "createdStarTime", title = "报警时间 开始 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Timestamp createdStarTime;
    @Schema(name = "createdEndTime", title = "报警时间 结束 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Timestamp createdEndTime;

    @Schema(name = "organizationName", title = "企业名称")
    private String organizationName;

    @Schema(name = "stationName", title = "驻勤点名称")
    private String stationName;

    @Schema(name = "projectName", title = "项目名称")
    private String projectName;

    @Schema(name = "superviseDepartIds", title = "监管归属Ids")
    private Collection<String> superviseDepartIds;

    @Schema(name = "fromSos", title = "是否来自Sos")
    private boolean fromSos;

    @Schema(name = "regionName", title = "针对晋城的区域过滤")
    private String regionName;

    @Schema(name = "searchModel", title = "搜索模式: APP端的查询使用: Personal; 其他使用Default")
    private SearchModel searchModel;

    public static enum SearchModel {
        Default,
        Personal
    }
}
