package com.bcxin.tenant.open.jdks;

import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.jdks.requests.SecurityStationReaderRequest;
import com.bcxin.tenant.open.jdks.requests.SecurityStationShortSearchRequest;
import com.bcxin.tenant.open.jdks.requests.StationStatisticsSearchRequest;
import com.bcxin.tenant.open.jdks.responses.SecurityStationDetailResponse;
import com.bcxin.tenant.open.jdks.responses.SecurityStationOverviewReaderResponse;
import com.bcxin.tenant.open.jdks.responses.SecurityStationShortResponse;
import com.bcxin.tenant.open.jdks.responses.StationStatisticsResponse;

import java.util.Collection;

/**
 *  RPC: 读取驻勤点信息
 */
public interface SecurityStationReaderRpcProvider {

    Collection<SecurityStationOverviewReaderResponse> search(SecurityStationReaderRequest request);

    SecurityStationDetailResponse get(String id);

    Collection<String> getSecurityStationIdsByOrganizationIds(Collection<String> organizationIds);

    Collection<String> getOrganizationIdsByStationIds(Collection<String> stationIds);

    Collection<StationStatisticsResponse> search(StationStatisticsSearchRequest request);

    EntityCollection<SecurityStationShortResponse> search(SecurityStationShortSearchRequest request);
}
