package com.bcxin.tenant.open.jdks;

import com.bcxin.tenant.open.infrastructures.enums.DispatchAccountType;
import com.bcxin.tenant.open.infrastructures.UserDetailResponse;
import com.bcxin.tenant.open.jdks.responses.RdDeviceDeskPermissionResponse;

public interface IdentityRpcProvider {
    UserDetailResponse getByEmployeeId(String employeeId, DispatchAccountType accountType);

    /**
     * 使用该接口来实现判断该用户所在的组织是否拥有调度台的权限【以职员的身份】
     * 以用户的身份查询项目岗点权限+所在企业+所拥有的管理权限..
     * @param employeeId
     * @return
     */
    RdDeviceDeskPermissionResponse getDeviceDeskPermission(String employeeId,String organizationId,
                                                           DispatchAccountType accountType,
                                                           String orgInstitutional,
                                                           String orgName,
                                                           String orgId);

    /**
     * 该接口用来获取该职员/自然人(监管账号的情况;仅派出所进行数据的合并)拥有的权限列表
     * @param tenantUserId
     * @param employeeId
     * @param isSupervise
     * @return
     */
    RdDeviceDeskPermissionResponse getMergedDeviceDeskPermission(String tenantUserId,
                                                                 String employeeId,
                                                                 boolean isSupervise,
                                                                 DispatchAccountType accountType,
                                                                 String orgInstitutional,
                                                                 String orgName,
                                                                 String orgId);
}
