package com.bcxin.tenant.open.jdks;

import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.jdks.requests.EmployeeAdvanceRequest;
import com.bcxin.tenant.open.jdks.requests.EmployeeDutyStatusRequest;
import com.bcxin.tenant.open.jdks.requests.EmployeeSearchRequest;
import com.bcxin.tenant.open.jdks.responses.*;

import java.util.Collection;

public interface EmployeeReaderRpcProvider {
    EmployeeDetailResponse get(String id, DeskType deskType);

    Collection<EmployeeOverviewResponse> search(EmployeeSearchRequest request);

    Collection<String> getEmployeeIdsByOrganizationIds(Collection<String> organizationIds);

    Collection<String> getEmployeeIdsByStationIds(Collection<String> stationIds);

    Collection<EmployeeOverviewResponse> getEmployeeOverviewByIds(Collection<String> ids);

    EntityCollection<EmployeeAdvanceResponse> search(EmployeeAdvanceRequest request);

    EmployeeCountResponse getEmployeeNumberByStationId(String stationId);

    Collection<EmployeeDutyStatusResponse> getEmployeesByStationIdAndDutyStatus(EmployeeDutyStatusRequest request);
}
