package com.bcxin.tenant.open.jdks;

import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.jdks.requests.*;
import com.bcxin.tenant.open.jdks.requests.wrappers.WrappedAttendanceWriterRequest;
import com.bcxin.tenant.open.jdks.responses.*;

import java.util.Collection;

/**
 * 签到
 */
public interface AttendanceRpcProvider {

    /**
     * 发起签到信息
     *
     * @param request
     */
    void create(WrappedAttendanceWriterRequest request);

    AttendanceValidationResponse validate(AttendanceValidationRequest request);

    Collection<AttendanceDetailReaderResponse> getByDay(String tenantEmployeeId, String createdDate);

    EntityCollection<AttendanceEmpReaderResponse> search(AttendanceSearchRequest request);

    EntityCollection<AttendanceGroupSearchResponse> search(AttendanceGroupSearchRequest request);

    EntityCollection<AttendanceGroupDetailSearchResponse> search(AttendanceGroupDetailSearchRequest request);

    void batchCommit(Collection<String> data);

    int cleanRecentlyRecords();

    Collection<MyAttendanceRecordResponse> searchMyRecords(MyAttendanceSearchRequest request);

    Collection<AttendanceResponse> search(AttendanceSearchByTypeRequest request);

    boolean checkIfEnableFaceValidation();
}
