/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructure.tx.components;

import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class UnitWorkTxImpl
implements UnitWork {
    private static ThreadLocal<Map<String, TransactionStatus>> _translationFlags = new InheritableThreadLocal<Map<String, TransactionStatus>>();
    private final PlatformTransactionManager transactionManager;

    public UnitWorkTxImpl(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String beginTransaction() {
        String txId = String.format("%s-%s", UUID.randomUUID(), Thread.currentThread().getId());
        if (_translationFlags.get() == null) {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setName("SomeTxName");
            def.setPropagationBehavior(0);
            TransactionStatus transactionStatus = this.transactionManager.getTransaction(TransactionDefinition.withDefaults());
            _translationFlags.set(Map.of(txId, transactionStatus));
        }
        return txId;
    }

    public void commit(String tid) {
        if (_translationFlags.get() == null || !_translationFlags.get().containsKey(tid)) {
            return;
        }
        TransactionStatus transactionStatus = _translationFlags.get().get(tid);
        if (transactionStatus != null) {
            this.transactionManager.commit(transactionStatus);
            _translationFlags.set(null);
        }
    }

    public void detachAll() {
    }

    public void detach(Aggregate aggregate) {
    }

    public <T extends Aggregate> void detachAll(Collection<T> aggregates) {
    }

    public void executeTran(Runnable runnable) {
        String trId = this.beginTransaction();
        try {
            runnable.run();
            this.commit(trId);
        }
        catch (Exception ex) {
            this.rollback(trId);
            throw ex;
        }
    }

    public void rollback(String tid) {
        if (_translationFlags.get() == null || !_translationFlags.get().containsKey(tid)) {
            return;
        }
        TransactionStatus transactionStatus = _translationFlags.get().get(tid);
        if (transactionStatus != null) {
            this.transactionManager.rollback(transactionStatus);
            _translationFlags.set(null);
        }
    }

    public void executeNewTran(Runnable runnable) {
        this.executeTran(runnable);
    }
}

