package com.bcxin.risk.sys;

import cn.hutool.http.HttpUtil;
import com.bcxin.risk.common.util.HttpContextUtils;
import com.bcxin.risk.log.UserOpLog;
import com.bcxin.risk.log.UserOpLogDao;
import com.bcxin.risk.user.domain.User;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * 用户操作日志工具类
 * 采用异步调用方式
 */
@Service
@Transactional
@Slf4j
public class UserOpLogUtil {

    @Resource
    private UserOpLogDao userOpLogDao;

    /**
     * 保存日志记录
     */
    public void log(String menu,String action,String obj,User user){
        UserOpLog log = new UserOpLog();
        HttpServletRequest request = HttpContextUtils.getHttpServletRequest();
        log.setIpAddress(HttpUtil.getClientIP(request));
        log.setTargetObj(obj);
        log.setMenu(UserOpMenu.get(menu));
        log.setAction(action);
        log.setUser(user);
        userOpLogDao.save(log);
    }


}
