package com.bcxin.risk.sys;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.domain.Dict;
import com.bcxin.risk.common.domain.MarketRegion;
import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.common.util.ConfigUtil;
import com.bcxin.risk.constant.Const;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.report.material.domain.MaterialFormOption;
import com.bcxin.risk.spring.SpringContextHolder;
import lombok.extern.slf4j.Slf4j;

import java.util.Collection;
import java.util.List;

/**
 * 系统基础信息相关的工具类
 * @author luopeng
 */
@Slf4j
public class SysBasicUtil {

	private static SysDictUtil sysDictUtil = SpringContextHolder.getBean(SysDictUtil.class);

	private static SysRegionUtil sysRegionUtil = SpringContextHolder.getBean(SysRegionUtil.class);

	private static SysMaterialOptionUtil sysMaterialOptionUtil = SpringContextHolder.getBean(SysMaterialOptionUtil.class);

	private static SysMarketRegionUtil sysMarketRegionUtil = SpringContextHolder.getBean(SysMarketRegionUtil.class);


	/**字典相关***/
	public static String getDictLabel(String value, String type, String defaultValue){
		return sysDictUtil.getDictLabel(value,type,defaultValue);
	}
	public static String getDictLabelByLikeType(String value, String type, String defaultValue){
		return sysDictUtil.getDictLabelByLikeType(value,type,defaultValue);
	}


	public static String getDictValue(String label, String type, String defaultLabel){
		return sysDictUtil.getDictLabel(label,type,defaultLabel);
	}

	public static Collection<Dict> getDictList(String type){
		return sysDictUtil.getDictList(type);
	}

	public static String getDictListJson(String type){
		return sysDictUtil.getDictListJson(type);
	}

	/*** option相关 ***/
	public static String getOptionLabel(String value, String type, String defaultValue){
		return sysMaterialOptionUtil.getOptionLabel(value,type,defaultValue);
	}

	public static Collection<MaterialFormOption> getOptionList(String type){
		return sysMaterialOptionUtil.getOptionList(type);
	}

	public static String getConfig(String key){
		return ConfigUtil.getValue(key);
	}

	public static Region getRegionById(String id){
		return sysRegionUtil.getRegionById(id);
	}


	public static String getProvinceRegionNameById(String id){
		Region region = sysRegionUtil.getProvinceRegionById(id);
		if(region != null){
			if (StringUtil.isNotEmpty(region.getProvince())){
				return region.getProvince();
			}
		}
		return Const.BLANK_CHAR;
	}


	public static String getRegionNameById(String id){
		Region region = sysRegionUtil.getRegionById(id);
		String name = "";
		if(region != null){
			if(StringUtil.isNotEmpty(region.getProvince())){
				name = region.getProvince();
			} else if (StringUtil.isNotEmpty(region.getCity())){
				name = region.getCity();
			} else if (StringUtil.isNotEmpty(region.getArea())){
				name = region.getArea();
			}
		}
		return name;
	}

	/**
	 * 获得开拓省市的中文名称
	 * @param id
	 * @return
	 */
	public static String getMarketRegionNameById(Long id){
		MarketRegion region = sysMarketRegionUtil.getBlazerMarket(id);
		if (id == Long.parseLong(DictConst.REGION_CHINA)) {
			return "全国";
		}
		return StringUtil.isEmpty(region.getProvince())?region.getCity():region.getProvince();
	}

	/**
	 * 获得办事区域
	 * @return
	 */
	public static List findMarketRegionByIndependent(){
		return sysMarketRegionUtil.findRegionByIndependent();
	}

}
