package com.bcxin.risk.log;

import com.alibaba.fastjson.JSON;
import com.bcxin.risk.common.util.WebUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import java.util.Map;

@Service
public class SysLogUtil {

    @Autowired
    private SysLogDao sysLogDao;

    /**
     * 保存日志
     * @param msg
     * @param logType
     * @param e
     */
    public void saveLog(String msg,String logType,Exception e){
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        if(request!=null){
            String ip = WebUtil.getHost(request);
            String uri=request.getRequestURI();
            String userAgent=request.getHeader("user-agent");
            String method=request.getMethod();
            Map<String, String[]> param=request.getParameterMap();
            String paramJson=JSON.toJSON(param).toString();
            //保存到日志到记录表中
            SysLog log = new SysLog();
            if(e!=null){
                log.setException(getStackMessage(e));
            }
            log.setContent(msg);
            log.setCreateOn(new Date());
            log.setIp(ip);
            log.setReqParam(paramJson);
            log.setUrl(uri);
            log.setUserAgent(userAgent);
            log.setMethod(method);
            log.setLogType(logType);
            sysLogDao.save(log);
        }
    }

    /**
     * 获取异常堆栈信息
     * @param e
     * @return
     */
    public String getStackMessage(Exception e){
        ByteArrayOutputStream buf = new java.io.ByteArrayOutputStream();
        try {
            e.printStackTrace(new java.io.PrintWriter(buf, true));
            String expMessage = buf.toString();
            return expMessage;
        }catch (Exception ex){
            return "";
        }finally {
            try {
                buf.close();
            }catch (Exception ex1){

            }
        }
    }
}
