package com.bcxin.risk.log;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.enums.OperateLogTypeEnum;
import com.bcxin.risk.order.OrderForm;
import com.bcxin.risk.order.OrderFormDao;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.ByteArrayOutputStream;
import java.util.Date;
import java.util.concurrent.Future;

/**
 * @author hzp
 * 日志工具类
 * 由于使用了异步，需要加Transactional
 */
@Service
@Transactional
@Slf4j
public class LogUtil {

    @Autowired
    OperateLogDao operateLogDao;
    @Autowired
    OrderFormDao orderFormDao;

    @Async
    public void saveOperateLog(String ip,Long userId, String bizId,OperateLogTypeEnum typeEnum,String content,String success){
        OrderForm orderForm=orderFormDao.findOrderFormByOid(Long.parseLong(bizId));
        OperateLog operateLog = new OperateLog();
        operateLog.setIp(ip);
        operateLog.setUserId(userId);
        operateLog.setContent(typeEnum.getAlias());
        operateLog.setOperateType(typeEnum.getKey());
        operateLog.setBizId(orderForm.getOrderNo());
        operateLog.setActivityId(orderForm.getActivity().getOid());
        operateLog.setActivityName(orderForm.getActivity().getName());
        operateLog.setOperateTime(new Date());
        operateLog.setCreateOn(new Date());
        operateLog.setUpdateOn(new Date());
        operateLog.setContent(content);
        operateLog.setSuccess(success);
        saveOperateLog(operateLog);
    }

    @Async
    public void saveOperateLog(String ip,Long userId, OperateLogTypeEnum typeEnum,String exceptionMsg){
        OperateLog operateLog = new OperateLog();
        operateLog.setIp(ip);
        operateLog.setUserId(userId);
        operateLog.setContent(typeEnum.getAlias());
        operateLog.setOperateType(typeEnum.getKey());
        operateLog.setOperateTime(new Date());
        operateLog.setCreateOn(new Date());
        operateLog.setUpdateOn(new Date());
        operateLog.setSuccess(DictConst.Y);
        if(StringUtil.isNotEmpty(exceptionMsg)){
            operateLog.setSuccess(DictConst.N);
            operateLog.setException(exceptionMsg);
        }
        saveOperateLog(operateLog);
    }



    @Async
    public void saveOperateLog(String ip,Long userId, OperateLogTypeEnum typeEnum,Exception e){
        saveOperateLog(ip,userId,typeEnum.getAlias(),typeEnum,e);
    }
    @Async
    public void saveOperateLog(String ip,Long userId, String content, OperateLogTypeEnum typeEnum,Exception e){
        saveOperateLog(ip,userId,content,typeEnum,null,null,e);
    }

    @Async
    public void saveOperateLog(String ip,Long userId, String content, OperateLogTypeEnum typeEnum,Long orderId,Exception e){
        OrderForm orderForm=orderFormDao.findOrderFormByOid(orderId);
        OperateLog operateLog = new OperateLog();
        operateLog.setIp(ip);
        operateLog.setUserId(userId);
        operateLog.setContent(content);
        operateLog.setOperateType(typeEnum.getKey());
        operateLog.setBizId(orderForm.getOrderNo());
        operateLog.setSourceId(orderForm.getOrderNo());
        operateLog.setActivityId(orderForm.getActivity().getOid());
        operateLog.setActivityName(orderForm.getActivity().getName());
        operateLog.setOperateTime(new Date());
        operateLog.setCreateOn(new Date());
        operateLog.setUpdateOn(new Date());
        operateLog.setSuccess(DictConst.Y);
        if(e!=null){
            operateLog.setSuccess(DictConst.N);
            operateLog.setException(getStackMessage(e));
        }
        saveOperateLog(operateLog);
    }

    @Async
    public void saveOperateLog(String ip,Long userId, String content, OperateLogTypeEnum typeEnum,String bizId,String sourceId,Exception e) {
        OperateLog operateLog = new OperateLog();
        operateLog.setIp(ip);
        operateLog.setUserId(userId);
        operateLog.setContent(content);
        operateLog.setOperateType(typeEnum.getKey());
        operateLog.setBizId(bizId);
        operateLog.setSourceId(sourceId);
        operateLog.setOperateTime(new Date());
        operateLog.setCreateOn(new Date());
        operateLog.setUpdateOn(new Date());
        operateLog.setSuccess(DictConst.Y);
        if(e!=null){
            operateLog.setSuccess(DictConst.N);
            operateLog.setException(getStackMessage(e));
        }
        saveOperateLog(operateLog);
    }

    /**
     * 保存
     * @param operateLog
     */
    @Async
    public Future<Boolean> saveOperateLog(OperateLog operateLog){
        operateLogDao.save(operateLog);
        return new AsyncResult<Boolean>(true);
    }

    /**
     * 获取异常堆栈信息
     * @param e
     * @return
     */
    public String getStackMessage(Exception e){
        ByteArrayOutputStream buf = new java.io.ByteArrayOutputStream();
        try {
            e.printStackTrace(new java.io.PrintWriter(buf, true));
            String expMessage = buf.toString();
            return expMessage;
        }catch (Exception ex){
            return "";
        }finally {
            try {
                buf.close();
            }catch (Exception ex1){

            }
        }
    }
}
