package com.bcxin.risk.log;

import com.bcxin.risk.common.util.DateUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Slf4j
public class CompareUtil {

    /**
     * 比较两个对象所有属性值是否有不同
     * @param obj1    第一个对象
     * @param obj2    第二个对象
     * @return 如果有不同则返回true否则返回false
     */
    public static String compareObj(Object obj1, Object obj2) {
        StringBuilder sb = new StringBuilder();
        try {
            Class clazz = obj1.getClass();
            Method[] methods = clazz.getMethods();
            List<String> textList = Lists.newArrayList();
            for (int i = 0; i < methods.length; i++) {
                Method method = methods[i];
                String name = StringUtils.uncapitalize(method.getName().replace("get", "").trim());
                if (method.getName().startsWith("get")) {
                    Object o1 = method.invoke(obj1);
                    Object o2 = method.invoke(obj2);
                    String s1 = o1 == null ? "" : o1.toString();// 避免空指针异常
                    String s2 = o2 == null ? "" : o2.toString();// 避免空指针异常
                    if (!s1.equals(s2)) {
                        sb.append(name).append(",");
                    }
                }
            }
        } catch (Exception e) {
            log.error("CompareUtil比较属性异常{}", e);
        }
        String name = "";
        if(sb.length() > 0){
            name = sb.substring(0, sb.length()-1);
        }

        return name;
    }


    /**
     * 对比差异，返回日志
     * @param oldObj
     * @param newObj
     * @return
     * @throws IntrospectionException
     */
    public static List<ChangeLog> compareChangeObject(Long marketRegionId,Object oldObj, Object newObj) throws IntrospectionException {
        List<ChangeLog> list=new ArrayList<>();
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(oldObj.getClass());
        } catch (IntrospectionException e1) {
            throw new IntrospectionException("获取class类异常");
        }
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        for (PropertyDescriptor pd : pds) {
            String name = pd.getName();
            try {
                Object oldVal = pd.getReadMethod().invoke(oldObj);
                Object newVal = pd.getReadMethod().invoke(newObj);
                boolean b = compareTwo(oldVal, newVal);
                if(!b){
                    ChangeLog changeLog=new ChangeLog(marketRegionId,"PSS",name,oldVal,newVal);
                    list.add(changeLog);
                }
            } catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalArgumentException("获取属性值异常", e);
            }
        }
        return list;
    }

    /**
     * 比较两个对象所有属性值是否有不同
     * @param obj1    第一个对象
     * @param obj2    第二个对象
     * @return 如果有不同则返回true否则返回false
     * @throws IntrospectionException
     */
    public static String compareObject(Object obj1, Object obj2) throws IntrospectionException {
        StringBuilder sb = new StringBuilder();
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(obj1.getClass());
        } catch (IntrospectionException e1) {
            throw new IntrospectionException("获取class类异常");
        }
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        for (PropertyDescriptor pd : pds) {
            String name = pd.getName();
            try {
                Object value1 = pd.getReadMethod().invoke(obj1);
                Object value2 = pd.getReadMethod().invoke(obj2);
                boolean b = compareTwo(value1, value2);
                if(!b){
                    sb.append(name).append(",");
                }
            } catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalArgumentException("获取属性值异常", e);
            }
        }
        String name = "";
        if(sb.length() > 0){
            name = sb.substring(0, sb.length()-1);
        }
        return name;
    }

    /**
     * 比较两个对象所有属性值是否有不同
     * @param obj1    第一个对象
     * @param obj2    第二个对象
     * @return Map 相同属性和不同属性的所有值，不同属性[|]分割。
     */
    public static Map<String, String> compareObjReturnMap(Object obj1, Object obj2) {
        Map<String, String> sameMap = new LinkedHashMap<>();
        Map<String, String> differMap = new LinkedHashMap<>();
        try {
            Class<? extends Object> clazz = obj1.getClass();
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; i++) {
                Method method = methods[i];
                String name = StringUtils.uncapitalize(method.getName().replace("get", "").trim());
                if (method.getName().startsWith("get")) {
                    Object o1 = method.invoke(obj1);
                    Object o2 = method.invoke(obj2);
                    String s1 = o1 == null ? "" : o1.toString();// 避免空指针异常
                    String s2 = o2 == null ? "" : o2.toString();// 避免空指针异常
                    String className = "";
                    if(o1 != null){
                        className = o1.getClass().getName();
                    }
                    if(o2 != null){
                        className = o2.getClass().getName();
                    }
                    if (!s1.equals(s2)) {
                        if(className.equals("java.util.Date")){
                            String s3 = "";
                            if(StringUtils.isNotBlank(s1)){
                                s3 = DateUtil.getFormat(s1);
                            }
                            String s4 = "";
                            if(StringUtils.isNotBlank(s2)){
                                s4 = DateUtil.getFormat(s2);
                            }
                            differMap.put(name, s3 + "|" + s4);
                        }else {
                            differMap.put(name, s1 + "|" + s2);
                        }
                    }else {
                        if(className.equals("java.util.Date")){
                            String s3 = "";
                            if(StringUtils.isNotBlank(s1)){
                                s3 = DateUtil.getFormat(s1);
                            }
                            sameMap.put(name, s3);
                        }else {
                            sameMap.put(name, s1);
                        }
                    }
                }
            }
        } catch (Exception e) {
            log.error("CompareUtil比较属性异常{}", e);
        }

        if(differMap.size() > 0){
            sameMap.putAll(differMap);
        }else {
            sameMap.clear();
        }
        return sameMap;
    }

    /**
     * 比较两个对象所有属性值是否有不同
     * @param obj1    第一个对象
     * @param obj2    第二个对象
     * @return Map 相同属性和不同属性的所有值，不同属性[|]分割。
     * @throws IntrospectionException
     * @throws ParseException
     */
    @SuppressWarnings("all")
    public static Map<String, String> compareObjReturnMap1(Object obj1, Object obj2) throws IntrospectionException, ParseException {
        Map<String, String> differMap = new LinkedHashMap<>();
        SimpleDateFormat df=new SimpleDateFormat("yyyy-MM-dd Hh:mm:ss");
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(obj1.getClass());
        } catch (IntrospectionException e1) {
            throw new IntrospectionException("获取class类异常");
        }
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        boolean isDiffer = false;
        for (PropertyDescriptor pd : pds) {
            String name = pd.getName();
            Class<?> type= pd.getPropertyType();
            try {
                Object value1 = pd.getReadMethod().invoke(obj1);
                Object value2 = pd.getReadMethod().invoke(obj2);
                if(type.equals(Date.class)){
                    if(value1 != null && StringUtils.isNotBlank(value1.toString())){
                        value1 = df.format(value1);
                    }
                    if(value2 != null && StringUtils.isNotBlank(value2.toString())){
                        value2 =df.format(value2);
                    }
                }
                boolean b = compareObject(differMap, name, value1, value2);
                if(b){
                    isDiffer = true;
                }
            } catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalArgumentException("获取属性值异常", e);
            }
        }
        if(!isDiffer){
            differMap.clear();
        }
        return differMap;
    }

    private static boolean compareObject(Map<String, String> differMap,
                                         String name, Object value1, Object value2) {
        boolean isDiffer = false;
        boolean b = compareTwo(value1, value2);
        if(!b){
            isDiffer = true;
            differMap.put(name, value1 + " <> " + value2);
        }else {
            differMap.put(name, value1 + " = " + value2);
        }
        return isDiffer;
    }

    /**
     * 对比两个数据是否内容相同
     * @param  object1,object2
     * @return boolean类型
     */
    public static boolean compareTwo(Object object1, Object object2){
        if(object1==null && object2==null){
            return true;
        }
        if(object1==null && object2!=null){
            return false;
        }
        if(object1.equals(object2)){
            return true;
        }
        return false;
    }
}
