package com.bcxin.risk.log;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.ActivityDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.domain.Dict;
import com.bcxin.risk.common.domain.MarketRegion;
import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.constant.Const;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.dynamic.DynamicPanelDao;
import com.bcxin.risk.dynamic.DynamicUtil;
import com.bcxin.risk.enums.BillCategoryEnum;
import com.bcxin.risk.enums.BillTypeEnum;
import com.bcxin.risk.report.material.dao.MaterialFormMenuDao;
import com.bcxin.risk.report.material.dao.MaterialFormMenuTemplateDao;
import com.bcxin.risk.report.material.domain.MaterialFormMenu;
import com.bcxin.risk.report.material.domain.MaterialFormMenuTemplate;
import com.bcxin.risk.sys.SysDictUtil;
import com.bcxin.risk.sys.SysMarketRegionUtil;
import com.bcxin.risk.sys.SysMaterialOptionUtil;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * 保存差异日志
 */
@Service
@Transactional
@Slf4j
public class ChangeLogUtil {

    @Autowired
    private ChangeLogDao changeLogDao;
    @Autowired
    private SysMaterialOptionUtil sysMaterialOptionUtil;
    @Autowired
    private SysMarketRegionUtil sysMarketRegionUtil;
    @Autowired
    private MaterialFormMenuDao materialFormMenuDao;
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private MaterialFormMenuTemplateDao materialFormMenuTemplateDao;
    @Autowired
    private DynamicUtil dynamicUtil;
    @Autowired
    private DynamicPanelDao dynamicPanelDao;

    /**
     * 修改日志显示状态
     */
    public void updateLogShowStatus(String activityNo,String showStatus){
        Activity activity=activityDao.findActivityByActivityNo(activityNo);
        // 验证是否有新的未显示的日志
        boolean flag=changeLogDao.checkLogUnShow(activityNo);
        if(flag) {
            // 保存到动态看板
            dynamicUtil.saveDynamicActUpdateLog(activity.getOid());
        }
        changeLogDao.updateLogShowStatus(activityNo, showStatus);

    }

    /**
     * 保存活动基本信息变更日志
     * @param billId
     * @param old
     * @param now
     */
    @Async
    public void saveActChangeLog(MarketRegion marketRegion, String platform, String billId,String activityNo, Map<String,String> old, Map<String,String> now){
        Long marketId=marketRegion!=null ? marketRegion.getOid() : null;
        saveChangeLog(marketId,platform,billId,activityNo,BillCategoryEnum.ACTIVITY.getKey(),BillTypeEnum.ACTIVITY_INFO.getKey(),old,now);
    }


    /**
     * 保存材料主体修改日志
     * @param activityNo
     * @param platform
     */
    @Async
    public void saveActModuleChangeLog(String activityNo,String platform,String changeContent){
        Activity activity=activityDao.findActivityByActivityNo(activityNo);
        // 获取落地省份
        MarketRegion marketRegion=sysMarketRegionUtil.getBlazerMarketByCity(activity.getCity().getOid());
        Long marketRegionId=marketRegion!=null ? marketRegion.getOid() : null;
        ChangeLog changeLog=new ChangeLog();
        changeLog.setBillId(activity.getOid()+"");
        changeLog.setActivityNo(activity.getActivityNo());
        changeLog.setBillCategory(BillCategoryEnum.ACTIVITY.getKey());
        changeLog.setBillType(BillTypeEnum.MATERIAL_MODULE_INFO.getKey());
        changeLog.setFlagId(activity.getOid()+"");
        changeLog.setMarkerRegionId(marketRegionId);
        changeLog.setSource(platform);
        changeLog.setSourceVal("修改材料");
        changeLog.setNowVal("修改材料");
        changeLog.setIsNew(DictConst.Y);
        changeLog.setIsUpdate(DictConst.Y);
        changeLog.setIsShow(DictConst.N);
        changeLog.setChangeDate(new Date());
        changeLog.setText("活动材料");
        changeLog.setRemark(changeContent);
        changeLogDao.saveChangeLog(changeLog);
//        // 保存到动态看板
//        dynamicUtil.saveDynamicActUpdateLog(activity.getOid());
    }

    /**
     * 保存材料差异日志
     * @param billId
     * @param oldMapList
     * @param newMapList
     */
    @Async
    public void saveMaterialChangeLog(MarketRegion marketRegion,String platform,String billId,String activityNO,List<Map<String,Object>> oldMapList,List<Map<String,Object>> newMapList){
        saveMaterialModuleLog(marketRegion,platform,billId,activityNO,oldMapList,newMapList);
        // 保存明细
//        saveMaterialModuleDetailLog(marketRegion,platform,billId,activityNO,oldMapList,newMapList);
    }

    /**
     * 保存材料
     * @param marketRegion
     * @param platform
     * @param billId
     * @param activityNO
     * @param menuCode
     */
    public void saveMaterialMenuLog(MarketRegion marketRegion,String platform,String billId,String activityNO,String menuCode){
        List<String> menuCodeList=new ArrayList<>();
        menuCodeList.add(menuCode);
        List<MaterialFormMenuTemplate> list=materialFormMenuTemplateDao.findByMenus(menuCodeList);
        String menuName="";
        if(list!=null && list.size()>0){
            menuName=list.get(0).getMenuName();
        }
        Long marketRegionId=marketRegion!=null ? marketRegion.getOid() : null;
        ChangeLog changeLog = new ChangeLog();
        changeLog.setText(menuName);
        changeLog.setNowVal("材料有修改");
        changeLog.setSourceVal("材料有修改");
        changeLog.setSource(platform);
        changeLog.setChangeDate(new Date());
        changeLog.setIsUpdate(DictConst.Y);
        changeLog.setIsNew(DictConst.Y);
        changeLog.setIsShow(DictConst.N);
        changeLog.setMarkerRegionId(marketRegionId);
        changeLog.setActivityNo(activityNO);
        changeLog.setBillId(billId);
        changeLog.setFlagId(menuCode);
        changeLog.setBillType(BillTypeEnum.MATERIAL_INFO.getKey());
        changeLog.setBillCategory(BillCategoryEnum.ACTIVITY.getKey());
        changeLogDao.changeLogStatus(DictConst.N,DictConst.Y, billId, BillCategoryEnum.ACTIVITY.getKey(), BillTypeEnum.MATERIAL_INFO.getKey(),menuCode);
        changeLogDao.saveChangeLog(changeLog);
//        // 保存到动态看板
//        dynamicUtil.saveDynamicActUpdateLog(Long.parseLong(billId));
    }

    /**
     * 只记录菜单模块修改日志，不记录明细
     * @param marketRegion
     * @param platform
     * @param billId
     * @param activityNO
     * @param oldMapList
     * @param newMapList
     */
    public void saveMaterialModuleLog(MarketRegion marketRegion,String platform,String billId,String activityNO,List<Map<String,Object>> oldMapList,List<Map<String,Object>> newMapList){
        if (oldMapList == null || newMapList == null || oldMapList.isEmpty()) {
            return;
        }
        boolean isChange=false;
        boolean isAdd=false;
        boolean isDelete=false;
        String menuId="";

        Map<String,Map<String,Object>> newMap=new HashMap<>();
        Map<String,Map<String,Object>> oldMap=new HashMap<>();
        List<String> listNew=new ArrayList<>();
        List<String> listOld=new ArrayList<>();
        // 合并层新的map数据，在进行对比
        Map<String,Map<String,Object>> map=new HashMap<>();
        for (Map<String, Object> tmp : newMapList) {
            String attrCode = tmp.get("attrCode").toString();
            String newValue = tmp.get("value").toString();
            menuId=tmp.get("menuId").toString();
            Map<String,Object> tmpMap=new HashMap<>();
            tmpMap.put("newVal",newValue);
            tmpMap.put("oldVal",newValue);
            map.put(attrCode,tmpMap);
            listNew.add(attrCode);
        }

        for (Map<String, Object> tmp : oldMapList) {
            String attrCode = tmp.get("attrCode").toString();
            String oldValue = tmp.get("value").toString();
            if(map.containsKey(attrCode)){
                Map<String,Object> tmpMap=map.get(attrCode);
                tmpMap.put("oldVal",oldValue);
            }else{
                Map<String,Object> tmpMap=new HashMap<>();
                tmpMap.put("newVal","");
                tmpMap.put("oldVal",oldValue);
                map.put(attrCode,tmpMap);
            }
            listOld.add(attrCode);
        }

        String [] defaultAttrCode={"A1","B38","B1","B2","B42","D1","D2"};
        List<String>defaultAttrCodeList=Arrays.asList(defaultAttrCode);
        for(String key : map.keySet()){
            Map<String,Object> tmpMap=map.get(key);
            if(!Objects.equals(tmpMap.get("newVal"),tmpMap.get("oldVal"))){
                isChange=true;
                break;
            }
            // 默认code不对比
            boolean isNeedCompare=true;
            for(String s : defaultAttrCodeList){
                if(key.startsWith(s)){
                    isNeedCompare=false;
                }
            }
            if(isNeedCompare) {
                if (listOld.contains(key) && !listNew.contains(key)) {
                    isDelete = true;
                    isChange = true;
                    break;
                }
                if (!listOld.contains(key) && listNew.contains(key)) {
                    isAdd = true;
                    isChange = true;
                    break;
                }
            }
        }


        // 保存日志
        if(isChange){
            if(StringUtil.isEmpty(menuId)){
                return;
            }
            MaterialFormMenu materialFormMenu=materialFormMenuDao.findMaterialFormMenuByOid(Long.parseLong(menuId));
            Long marketRegionId=marketRegion!=null ? marketRegion.getOid() : null;
            ChangeLog changeLog = new ChangeLog();
            changeLog.setText(materialFormMenu.getMenuName());
            changeLog.setNowVal("材料有修改");
            changeLog.setSourceVal("材料有修改");
            changeLog.setSource(platform);
            changeLog.setChangeDate(new Date());
            changeLog.setIsUpdate(DictConst.Y);
            changeLog.setIsNew(DictConst.Y);
            changeLog.setIsShow(DictConst.N);
            changeLog.setMarkerRegionId(marketRegionId);
            changeLog.setActivityNo(activityNO);
            changeLog.setBillId(billId);
            changeLog.setFlagId(menuId);
            changeLog.setBillType(BillTypeEnum.MATERIAL_INFO.getKey());
            changeLog.setBillCategory(BillCategoryEnum.ACTIVITY.getKey());
            changeLogDao.changeLogStatus(DictConst.N,DictConst.Y, billId, BillCategoryEnum.ACTIVITY.getKey(), BillTypeEnum.MATERIAL_INFO.getKey(),menuId);
            changeLogDao.saveChangeLog(changeLog);
//            // 保存到动态看板
//            dynamicUtil.saveDynamicActUpdateLog(Long.parseLong(billId));
        }
    }

    /**
     * 保存菜单模块修改明细
     * @param marketRegion
     * @param platform
     * @param billId
     * @param activityNO
     * @param oldMapList
     * @param newMapList
     */
    public void saveMaterialModuleDetailLog(MarketRegion marketRegion,String platform,String billId,String activityNO,List<Map<String,Object>> oldMapList,List<Map<String,Object>> newMapList){
        try {
            if (oldMapList == null || newMapList == null) {
                return;
            }
            List<ChangeLog> list = new ArrayList<>();
            String menuId="";
            for (Map<String, Object> oldMap : oldMapList) {
                String attrCode = oldMap.get("attrCode").toString();
                String attrType=oldMap.get("attrType").toString();
                String optionType=oldMap.containsKey("optionType") ? oldMap.get("optionType").toString() : "";
                String attrName = oldMap.get("attrName").toString();
                String value = oldMap.get("value").toString();
                String newValue = "";
                menuId=oldMap.get("menuId").toString();

                // 验证差异
                for (Map<String, Object> newMap : newMapList) {
                    String newAttrCode = newMap.get("attrCode").toString();
                    newValue = newMap.get("value").toString();
                    if (attrCode.equals(newAttrCode)) {
                        // 对比值
                        if (!Objects.equals(value,newValue)) {
                            String transferValue=setOptionValue(attrType,optionType,value);
                            String transferNewValue=setOptionValue(attrType,optionType,newValue);
                            Long marketRegionId=marketRegion!=null ? marketRegion.getOid() : null;
                            ChangeLog changeLog = new ChangeLog(marketRegionId,platform,attrCode, attrName, transferValue, transferNewValue);
                            list.add(changeLog);
                        }
                    }
                }
            }

            Map<String,Map<String,Object>> newMap=new HashMap<>();
            Map<String,Map<String,Object>> oldMap=new HashMap<>();
            for (Map<String, Object> tmp : newMapList) {
                String newAttrCode = tmp.get("attrCode").toString();
                newMap.put(newAttrCode,tmp);
            }
            for (Map<String, Object> tmp : oldMapList) {
                String oldAttrCode = tmp.get("attrCode").toString();
                oldMap.put(oldAttrCode,tmp);
            }

            // 获取新增
            for(String key : newMap.keySet()){
                if(!oldMap.containsKey(key)){
                    // 新增
                    Map<String,Object> tmp=newMap.get(key);
                    String attrCode = tmp.get("attrCode").toString();
                    String attrType=tmp.get("attrType").toString();
                    String optionType=tmp.containsKey("optionType") ? tmp.get("optionType").toString() : "";
                    String attrName = tmp.get("attrName").toString();
                    String value = tmp.get("value").toString();
                    String transferNewValue=setOptionValue(attrType,optionType,value);
                    Long marketRegionId=marketRegion!=null ? marketRegion.getOid() : null;
                    ChangeLog changeLog = new ChangeLog(marketRegionId,platform,attrCode, attrName, "", transferNewValue);
                    list.add(changeLog);
                }
            }

            // 获取删除
            for(String key : oldMap.keySet()){
                if(!newMap.containsKey(key)){
                    // 删除
                    Map<String,Object> tmp=oldMap.get(key);
                    String attrCode = tmp.get("attrCode").toString();
                    String attrType=tmp.get("attrType").toString();
                    String optionType=tmp.containsKey("optionType") ? tmp.get("optionType").toString() : "";
                    String attrName = tmp.get("attrName").toString();
                    String value = tmp.get("value").toString();
                    String transferValue=setOptionValue(attrType,optionType,value);
                    Long marketRegionId=marketRegion!=null ? marketRegion.getOid() : null;
                    ChangeLog changeLog = new ChangeLog(marketRegionId,platform,attrCode, attrName, transferValue, "");
                    list.add(changeLog);
                }
            }

            if (list != null && list.size() > 0) {
                for (ChangeLog changeLog : list) {
                    changeLog.setBillId(billId);
                    changeLog.setActivityNo(activityNO);
                    changeLog.setBillCategory(BillCategoryEnum.ACTIVITY.getKey());
                    changeLog.setBillType(BillTypeEnum.MATERIAL_INFO.getKey());
                    changeLog.setFlagId(menuId);
                }
                changeLogDao.changeLogStatus(DictConst.N,DictConst.Y, billId, BillCategoryEnum.ACTIVITY.getKey(), BillTypeEnum.MATERIAL_INFO.getKey(),menuId);
                changeLogDao.insertBatch(list, 10);
//                // 保存到动态看板
//                dynamicUtil.saveDynamicActUpdateLog(Long.parseLong(billId));
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    /**
     * 保存变更日志
     * @param billId
     * @param billCategory
     * @param billType
     * @param old
     * @param now
     */
    @Async
    public void saveChangeLog(Long marketRegionId,String platform,String billId,String activityNo, String billCategory, String billType, Map<String,String> old,  Map<String,String> now){
        try {
            if(old==null || now==null){
                return;
            }
            List<ChangeLog> list = new ArrayList<>();
            for(String key : old.keySet()){
                if(!Objects.equals(old.get(key),now.get(key))){
                    String oldTransferVal=old.get(key);
                    String newTransferVal=now.get(key);
                    if(key.toUpperCase().equals("ACTIVITYTYPE")){
                        oldTransferVal=setTypeValue("ACTIVITYTYPE",oldTransferVal);
                        newTransferVal=setTypeValue("ACTIVITYTYPE",newTransferVal);
                    }else if(key.toUpperCase().equals("ADDRESSTYPE")){
                        oldTransferVal=setTypeValue("ADDRESSTYPE",oldTransferVal);
                        newTransferVal=setTypeValue("ADDRESSTYPE",newTransferVal);
                    }
                    ChangeLog changeLog=new ChangeLog(marketRegionId,platform,key,oldTransferVal,newTransferVal);
                    list.add(changeLog);
                }
            }

            if(list!=null && list.size()>0){
                for(ChangeLog changeLog : list){
                    changeLog.setBillId(billId);
                    changeLog.setActivityNo(activityNo);
                    changeLog.setBillCategory(billCategory);
                    changeLog.setBillType(billType);
                    changeLog.setFlagId(billId);
                }
                changeLogDao.changeLogStatus(DictConst.N,DictConst.Y,billId,billCategory,billType,billId);
                changeLogDao.insertBatch(list,10);
//                // 保存到动态看板
//                dynamicUtil.saveDynamicActUpdateLog(Long.parseLong(billId));
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }


    /**
     * 获取需要比对的map
     * @param activity
     * @return
     */
    public static Map<String,String> getCompareMap(Activity activity){
        Region province=activity.getProvince();
        Region city=activity.getCity();
        Region area=activity.getArea();
        Region unit=activity.getUnit();
        String actAddr="";
        String provinceStr=province!=null ? province.getProvince() :"";
        actAddr+=provinceStr;
        actAddr+=city!=null ? "-"+city.getCity() :"";
        actAddr+=area!=null ? "-"+area.getArea() :"";
        actAddr+=unit!=null ? "-"+unit.getArea() :"";

        Map<String,String> map=Maps.newHashMap();
        map.put("activityName",activity.getName());
        map.put("activityType",activity.getActivityType());
        map.put("address",activity.getAddress());
        map.put("actAddr",actAddr);
        map.put("addressType",activity.getAddressType());
        map.put("number",activity.getNumber());
        map.put("activityDate",activity.getStartDate()+"~"+activity.getEndDate());
        map.put("sponsor",activity.getSponsor());
        return map;
    }


    /**
     * 转换option值
     * @param attrType
     * @param value
     * @return
     */
    private String setOptionValue(String attrType,String optionType,String value) {
        if (DictConst.FIELDTYPE_CHECKBOX.equals(attrType)
                || DictConst.FIELDTYPE_SELECT.equals(attrType)
                || DictConst.FIELDTYPE_RADIO.equals(attrType)) {
            String[] options = value.split(",");
            String optionValue = Const.BLANK_CHAR;
            for (String option:options) {
                optionValue = optionValue + sysMaterialOptionUtil.getOptionLabel(option,optionType,Const.BLANK_CHAR) + ",";
            }
            if (optionValue.length()>0) {
                optionValue = optionValue.substring(0,optionValue.length());
            }
           return optionValue;
        }
        return value;
    }


    @Autowired
    private SysDictUtil sysDictUtil;
    private String setTypeValue(String type,String value){
        if(StringUtil.isEmpty(value)){
            return "";
        }
        Collection<Dict> list=sysDictUtil.getDictList(type);
        Map<String,String> map=Maps.newHashMap();
        for(Dict dict : list){
            map.put(dict.getValue(),dict.getLabel());
        }
        String [] tmp=value.split(",");
        for(int i=0;i<tmp.length;i++){
            tmp[i]=map.containsKey(tmp[i]) ? map.get(tmp[i]).toUpperCase() : tmp[i];
        }
        // 重新组装
        String newStr="";
        for(String s : tmp){
            newStr+=s+",";
        }
        if(StringUtil.isNotEmpty(newStr)){
            newStr=newStr.substring(0,newStr.length()-1);
        }
        return newStr;
    }
}
