package com.bcxin.risk.esign;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.collect.Maps;
import org.apache.commons.collections4.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @description 关键字处理辅助类
 * @author 宫清
 * @date 2019年8月2日 上午9:36:39
 * @since JDK1.7
 */
public class KeyParserHelper {

	private KeyParserHelper() {
	}

	// ------------------------------公有方法start--------------------------------------------

	/**
	 * @description 获取json下keyword关键字与坐标位置集合关联的map
	 * @param json json字符串
	 * @param page 页码,从1 开始
	 * @return
	 * @date 2019年8月2日 上午10:09:42
	 * @author 宫清
	 */
	public static Map<String, List<PosBean>> filterKeyMap(JSONObject json, Integer page) {
		Map<String, List<PosBean>> map = Maps.newHashMap();
		if (json == null || json.isEmpty()) {
			return map;
		}
		JSONArray dataArr = json.getJSONArray("data");
		if (dataArr.isEmpty() || dataArr.size() == 0) {
			return map;
		}

		for (int i = 0; i < dataArr.size(); i++) {
			JSONObject jobj = dataArr.getJSONObject(i);
			String key = jobj.getString("keyword"); // 关键字
			JSONArray posArr = jobj.getJSONArray("positionList");

			List<PageBean> list = new ArrayList(posArr.size());
			Iterator var4 = posArr.iterator();
			ParserConfig config = ParserConfig.getGlobalInstance();
			while(var4.hasNext()) {
				Object item =   var4.next();
				PageBean classItem = TypeUtils.cast(item, PageBean.class, config);
				list.add(classItem);
			}

			List<PageBean> pageList = list;
			Collections.sort(pageList);
			List<PosBean> posBeanList=new ArrayList<>();
//			page = page == null ? pageList.get(pageList.size() - 1).getPageIndex() : page;
			for (PageBean pageBean : pageList) {
//				if (pageBean.getPageIndex() == page) {
				posBeanList.addAll(buildPosList(pageBean.getCoordinateList(),pageBean.getPageIndex()));
//				}
			}
			map.put(key,posBeanList);
		}
		return map;
	}


	// ------------------------------公有方法end----------------------------------------------

	// ------------------------------私有方法start--------------------------------------------

	/**
	 * @description 获取某keyword下坐标位置集合
	 * @param posArr
	 * @return
	 * @date 2019年8月2日 上午10:07:50
	 * @author 宫清
	 */
	private static List<PosBean> buildPosList(List<PosBean> list,int pageIndex) {
		if (CollectionUtils.isEmpty(list)) {
			return list;
		}
//		Collections.sort(list);//这里应该逆序
		list=list.stream().sorted(Comparator.comparing(PosBean::getPosY).reversed()).filter(s -> {
			s.setPage(pageIndex);
			return true;
		}).collect(Collectors.toList());
//		Iterable<PosBean> itr = Iterables.filter(list, Predicates.equalTo(list.get(0)));
		return list;
	}



	// ------------------------------私有方法end----------------------------------------------

}
