package com.bcxin.risk.constant;

import com.bcxin.risk.sys.resources.ConfigResources;

/**
 * <b>Redis Key 值常量 </b>
 * @author 罗鹏
 */
public final class RedisKeyConst {

	private RedisKeyConst(){} //空的构造函数，避免实例化该类
	
	private final static String ENVI = "PSS";

	private final static String COLON = ":";

	private final static String CON = "_";

	private final static String MODULE_SYS = "SYS";

	private final static String MODULE_BUSINESS = "BUSINESS";

	private final static String REDIS_PREFIX_KEY = ENVI + COLON + "PG" + COLON + ConfigResources.PROFILE_ENVI + COLON;

	/**
	 * 一分钟
	 */
	public final static int TIMEOUT_ONE_MIN = 60;

	/**
	 * 三分钟
	 */
	public final static int TIMEOUT_THREE_MIN = 180;

	/**
	 * 五分钟
	 */
	public final static int TIMEOUT_FIVE_MIN = 300;

	/**
	 * 一小时
	 */
	public final static int TIMEOUT_ONE_HOUR = 3600;

	/**
	 * 半天
	 */
	public final static int TIMEOUT_HALF_DAY = 43200;

	/**
	 * 一天
	 */
	public final static int TIMEOUT_ONE_DAY = 86400;

	/**
	 * 一周
	 */
	public final static int TIMEOUT_ONE_WEEK = 604800;


	/**
	 * dict配置表
	 */
	public final static String REDIS_KEY_DICT = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "DICT";


	/**
	 * 区域配置表
	 */
	public final static String REDIS_KEY_REGION = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "REGION";

	/**
	 * 区域配置表，省
	 */
	public final static String REDIS_KEY_REGION_PROVINCE = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "REGION_PROVINCE";

	/**
	 * 区域配置表，市
	 */
	public final static String REDIS_KEY_REGION_CITY = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "REGION_CITY";


	/**
	 * 区域配置表，区
	 */
	public final static String REDIS_KEY_REGION_AREA = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "REGION_AREA";

	/**
	 * 材料多选项配置表
	 */
	public final static String REDIS_KEY_MATERIAL_OPTION = REDIS_PREFIX_KEY + MODULE_SYS + COLON + "MATERIAL_OPTION";


	/**
	 * 用户
	 */
	public final static String REDIS_KEY_USER_PREFIX = REDIS_PREFIX_KEY + MODULE_BUSINESS + COLON + "USER_";

	/**
	 * 用户验证码
	 */
	public final static String REDIS_KEY_USER_CAPTCHA_PREFIX = REDIS_PREFIX_KEY + MODULE_BUSINESS + COLON + "USER_CAPTCHA_";

	/**
	 * 活动材料class
	 */
	public final static String REDIS_KEY_REPORT_MATERIAL_CLASS_PREFIX = REDIS_PREFIX_KEY + MODULE_BUSINESS + COLON + "MATERIAL_CLASS_REPORT";

	/**
	 * 活动材料value
	 */
	public final static String REDIS_KEY_REPORT_MATERIAL_VALUE_PREFIX = REDIS_PREFIX_KEY + MODULE_BUSINESS + COLON + "MATERIAL_VALUE_REPORT";

	/**
	 * 机构服务
	 */
	public final static String REDIS_KEY_INDEX_ORG_VALUE_PREFIX = REDIS_PREFIX_KEY + MODULE_BUSINESS + COLON + "INDEX_ORG";

	/**
	 * 知识文库
	 */
	public final static String REDIS_KEY_INDEX_KNOWLEDGE_VALUE_PREFIX = REDIS_PREFIX_KEY + MODULE_BUSINESS + COLON + "INDEX_KNOWLEDGE";

	public final static String REDIS_KEY_TEMP = REDIS_PREFIX_KEY + "{1}" + COLON + "{2}";


}
