package com.bcxin.risk.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.risk.constant.Const;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * <b>保函数据处理类</b>
 * @author liumd
 * @date 2016年12月29日 上午9:14:58
 * @注意事项 </b>
 * <b>
 */
public class messageUtils {
	
	private static String charset = "UTF-8";
	private static String proxyHost = null;
	private static Integer proxyPort = null;
	
	/** 如果key对应的值是一个对象，返回该对象*/
	public static <T>T getObject(String data, Class<T> clazz, String key) {
		JSON json1 = getValueByKey(data, key);
		T ha = (T) JSONObject.toJavaObject(json1, clazz);
		return ha;
	}

	/** 如果key对应的值是一个对象列表，返回该对象列表*/
	@SuppressWarnings("rawtypes")
	public static <T> List getList(String data, Class<T> clazz, String key) {
		List<T> lis = new ArrayList<T>();
		JSONArray lis2 = (JSONArray) getValueByKey(data, key);
		if(lis2 != null){
			for (int i = 0; i < lis2.size(); i++) {
				JSON json = (JSON) JSON.toJSON(lis2.get(i));
				T ha = (T) JSONObject.toJavaObject(json, clazz);
				lis.add(ha);
			}
		}
		return lis.size() > 0 ? lis : null;
	} 
	
	/** 以JSONObject格式返回解密后的数据，方便取用*/
	public static JSONObject unPackageMessage(String data) {
		String deData = Apache64Util.base64Decode(data);
		JSONObject jsonback = JSONObject.parseObject(deData);
		return jsonback;
	}
	
	/** 通过Key获取String格式的数据(加密数据)
	 * */
	public static String getStringValueByKey(String data, String key) {
		String deData = Apache64Util.base64Decode(data);
		JSONObject jsonback = JSONObject.parseObject(deData);
		if(jsonback.get(key) == null){
			return null;
		}else{
			String requestCode = jsonback.get(key).toString();
			return requestCode;
		}
	}

	/** 通过Key获取String格式的数据
	 * */
	public static String getStringValueByKeyNoDecode(String data, String key) {
		JSONObject jsonback = JSONObject.parseObject(data);
		if(jsonback.get(key) == null){
			return null;
		}else{
			String requestCode = jsonback.get(key).toString();
			return requestCode;
		}
	}

	/** 通过Key获取String格式的数据(加密数据)
	 * */
	public static String getStringValueByKeyUnDecode(String data, String key) {
		JSONObject jsonback = JSONObject.parseObject(data);
		if(jsonback.get(key) == null){
			return null;
		}else{
			String requestCode = (String) jsonback.get(key);
			return requestCode;
		}
	}

	/** 通过Key获取Long格式的数据(加密数据)
	 * */
	public static Long getLongValueByKey(String data, String key) {
		String deData = Apache64Util.base64Decode(data);
		JSONObject jsonback = JSONObject.parseObject(deData);
		if(jsonback.get(key)==null){
			return null;
		}else{
			Long requestCode = Long.parseLong(jsonback.get(key).toString());
			return requestCode;
		}
	}
	
	/** 通过Key获取Integer格式的数据(加密数据)
	 * */
	public static Integer getIntegerValueByKey(String data, String key) {
		String deData = Apache64Util.base64Decode(data);
		JSONObject jsonback = JSONObject.parseObject(deData);
		if(jsonback.get(key)==null){
			return null;
		}else{
			int requestCode = Integer.parseInt(jsonback.get(key).toString());
			return requestCode;
		}
	}
	
	/** 通过Key获取String格式的数据(未加密数据)
	 * */
	public static String getStringValueByKeyJson(String data, String key) {
		JSONObject jsonback = JSONObject.parseObject(data);
		if(jsonback.get(key)==null){
			return null;
		}else{
			String requestCode = (String) jsonback.get(key);
			return requestCode;
		}
	}

	/** 通过Key获取String格式的数据(加密数据)
	 * */
	public static Map<String,String> getMapValue(String data) {
		String deData = Apache64Util.base64Decode(data);
		JSONObject jsonback = JSONObject.parseObject(deData);
		Map<String,String> map = Maps.newHashMap();
		for(String key : jsonback.keySet()){
			if(jsonback.get(key)!=null){
				String value = (String) jsonback.get(key);
				map.put(key,value);
			}
		}
		return map;
	}

	/** 通过Key获取String格式的数据(未加密数据)
	 * */
	public static Map<String,String> getMapValueUnDecode(String data) {
		JSONObject jsonback = JSONObject.parseObject(data);
		Map<String,String> map = Maps.newHashMap();
		for(String key : jsonback.keySet()){
			if(jsonback.get(key)!=null){
				String value = (String) jsonback.get(key);
				map.put(key,value);
			}
		}
		return map;
	}
	
	
	/** 通过Key获取JSON格式的数据
	 * */
	public static JSON getValueByKey(String data, String key) {
		JSONObject jsonback = JSONObject.parseObject(Apache64Util.base64Decode(data));
		if(jsonback.get(key)==null){
			return null;
		}else{
			JSON json = (JSON) JSON.toJSON(jsonback.get(key));
			return json;
		}
	}
	
	/** 封装map 外来标识*/
	public static String packageMap(Map<String,Object> map){
		map.put("webType","PSS");
		JSONObject json = new JSONObject(map);
		return Apache64Util.base64Encode(json.toString());
	}


	/**
	 * 获取request
	 * @return
	 */
	public static HttpServletRequest getRequest(){
		return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
	}
	
	
	/** 封装字符串*/
	public static String packageString(String  json){
		return Apache64Util.base64Encode(json);
	}
	
	/** 返回数据给保函*/
	public static void returnMessage(String data,HttpServletResponse response) {
		response.setCharacterEncoding("utf-8");
		try {
			PrintWriter out = response.getWriter();  
			out.print(data);  
			out.flush();
			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public static String doGet(String url) throws Exception {
        URL localURL = new URL(url);
        URLConnection connection = openConnection (localURL);
        HttpURLConnection httpURLConnection = (HttpURLConnection) connection;
        httpURLConnection.setRequestProperty("contentType", "utf-8");  
        httpURLConnection.setConnectTimeout(5 * 1000);  
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader reader = null;
        StringBuffer resultBuffer = new StringBuffer();
        String tempLine = null;
        if (httpURLConnection.getResponseCode() >= 300) {
            throw new Exception("HTTP Request is not success, Response code is " + httpURLConnection.getResponseCode());
        }
        try {
            inputStream = httpURLConnection.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            reader = new BufferedReader(inputStreamReader);
            while ((tempLine = reader.readLine()) != null) {
                resultBuffer.append(tempLine);
            }
        } finally {
            if (reader != null) {
                reader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return resultBuffer.toString();
    }
	
	public static String doPostPackaging(String url, String data) throws Exception {
		List<NameValuePair> formParams  = Lists.newArrayList();
		formParams.add(new BasicNameValuePair("data",data));
		formParams.add(new BasicNameValuePair("webType", Const.ENVI));
		String json = BcxinHttpUtil.sendPostRequest(url, formParams);
		return json;
	}

	public static String doPost(String url, Map<String,String> map) throws Exception {
		List<NameValuePair> formParams  = Lists.newArrayList();
		Iterator<Map.Entry<String,String>> it = map.entrySet().iterator();
		while(it.hasNext()) {
			Map.Entry<String, String> entry = it.next();
			String key = entry.getKey();
			String value = entry.getValue();
			formParams.add(new BasicNameValuePair(key,value));
		}
		String json = BcxinHttpUtil.sendPostRequest(url, formParams);
		return json;
	}


	private static URLConnection openConnection(URL localURL) throws IOException {
        URLConnection connection;
        if (proxyHost != null && proxyPort != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            connection = localURL.openConnection(proxy);
        } else {
            connection = localURL.openConnection();
        }
        return connection;
    }

	
	public static String getCharset() {
		return charset;
	}

	public static void setCharset(String charset) {
		messageUtils.charset = charset;
	}

	public static String getProxyHost() {
		return proxyHost;
	}

	public static void setProxyHost(String proxyHost) {
		messageUtils.proxyHost = proxyHost;
	}

	public static Integer getProxyPort() {
		return proxyPort;
	}

	public static void setProxyPort(Integer proxyPort) {
		messageUtils.proxyPort = proxyPort;
	}

	
	/**
     * Do POST request
     * @param url
//     * @param parameterMap
     * @return
     * @throws Exception 
     */
    public static String doPost2(String url, String data) {
        /* Translate parameter map to parameter date string */
        StringBuffer parameterBuffer = new StringBuffer();
		parameterBuffer.append("data").append("=").append(data);
		StringBuffer resultBuffer = new StringBuffer();
        try {
			URL localURL = new URL(url);
			URLConnection connection = openConnection(localURL);
			HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
			httpURLConnection.setDoOutput(true);
			httpURLConnection.setRequestMethod("POST");
			httpURLConnection.setRequestProperty("Accept-Charset", charset);
			httpURLConnection.setRequestProperty("contentType", charset);  
			httpURLConnection.setConnectTimeout(5 * 1000);
			httpURLConnection.setRequestProperty("Content-Length", String.valueOf(parameterBuffer.length()));
			
			OutputStream outputStream = null;
			OutputStreamWriter outputStreamWriter = null;
			InputStream inputStream = null;
			InputStreamReader inputStreamReader = null;
			BufferedReader reader = null;
			String tempLine = null;
			try {
			    outputStream = httpURLConnection.getOutputStream();
			    outputStreamWriter = new OutputStreamWriter(outputStream,charset);
			    outputStreamWriter.write(parameterBuffer.toString());
			    outputStreamWriter.flush();
			    if (httpURLConnection.getResponseCode() >= 300) {
			        throw new Exception("HTTP Request is not success, Response code is " + httpURLConnection.getResponseCode());
			    }
			    inputStream = httpURLConnection.getInputStream();
			    inputStreamReader = new InputStreamReader(inputStream ,charset);
			    reader = new BufferedReader(inputStreamReader);
			    while ((tempLine = reader.readLine()) != null) {
			        resultBuffer.append(tempLine);
			    }
			} finally {
			    if (outputStreamWriter != null) {
			        outputStreamWriter.close();
			    }
			    if (outputStream != null) {
			        outputStream.close();
			    }
			    if (reader != null) {
			        reader.close();
			    }
			    if (inputStreamReader != null) {
			        inputStreamReader.close();
			    }
			    if (inputStream != null) {
			        inputStream.close();
			    }
			}
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (ProtocolException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
        return resultBuffer.toString();
    }
	

}
