package com.bcxin.risk.common.util.compose;

import javax.crypto.*;
import javax.crypto.spec.DESKeySpec;
import java.io.*;
import java.security.SecureRandom;

public class DESUtil {

	/**
	* 加密
	* @param datasource byte[]
	* @param password String
	* @return byte[]
	 * @throws BadPaddingException 
	 * @throws IllegalBlockSizeException 
	*/
	public static byte[] encrypt(byte[] datasource, String password) throws Exception { 
		SecureRandom random = new SecureRandom();
		DESKeySpec desKey = new DESKeySpec(password.getBytes());
		//创建一个密匙工厂，然后用它把DESKeySpec转换成
		SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
		SecretKey securekey = keyFactory.generateSecret(desKey);
		//Cipher对象实际完成加密操作
		Cipher cipher = Cipher.getInstance("DES");
		//用密匙初始化Cipher对象
		cipher.init(Cipher.ENCRYPT_MODE, securekey, random);
		//现在，获取数据并加密
		//正式执行加密操作
		return cipher.doFinal(datasource);
	}
	
	/**
	* 解密
	* @param src byte[]
	* @param password String
	* @return byte[]
	* @throws Exception
	*/
	public static byte[] decrypt(byte[] src, String password) throws Exception {
		// DES算法要求有一个可信任的随机数源
		SecureRandom random = new SecureRandom();
		// 创建一个DESKeySpec对象
		DESKeySpec desKey = new DESKeySpec(password.getBytes());
		// 创建一个密匙工厂
		SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
		// 将DESKeySpec对象转换成SecretKey对象
		SecretKey securekey = keyFactory.generateSecret(desKey);
		// Cipher对象实际完成解密操作
		Cipher cipher = Cipher.getInstance("DES");
		// 用密匙初始化Cipher对象
		cipher.init(Cipher.DECRYPT_MODE, securekey, random);
		// 真正开始解密操作
		return cipher.doFinal(src);
	}
	
	public static void encryptFile(String file, String destFile, String key) throws Exception { 
	    DESKeySpec desKey = new DESKeySpec(key.getBytes());
	    SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
	    SecretKey securekey = keyFactory.generateSecret(desKey);
	    Cipher cipher = Cipher.getInstance("DES");
	    cipher.init(Cipher.ENCRYPT_MODE, securekey); 
	    InputStream is = new FileInputStream(file); 
	    OutputStream out = new FileOutputStream(destFile); 
	    CipherInputStream cis = new CipherInputStream(is, cipher); 
	    byte[] buffer = new byte[1024]; 
	    int r; 
	    while ((r = cis.read(buffer)) > 0) { 
	        out.write(buffer, 0, r); 
	    } 
	    cis.close(); 
	    is.close(); 
	    out.close();
	}
	
	public static byte[] decryptFile(byte[] src, String key) throws Exception {
		DESKeySpec desKey = new DESKeySpec(key.getBytes());
	    SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
	    SecretKey securekey = keyFactory.generateSecret(desKey);
	    Cipher cipher = Cipher.getInstance("DES"); 
	    cipher.init(Cipher.DECRYPT_MODE, securekey);
	    InputStream is = new ByteArrayInputStream(src); 
//	    OutputStream out = new FileOutputStream(tempFile);
	    ByteArrayOutputStream out = new ByteArrayOutputStream();
	    CipherOutputStream cos = new CipherOutputStream(out, cipher); 
	    byte[] buffer = new byte[1024]; 
	    int r; 
	    while ((r = is.read(buffer)) >= 0) { 
	        cos.write(buffer, 0, r); 
	    }
	    cos.flush();
	    cos.close(); 
	    byte[] result = out.toByteArray();
	    out.close(); 
	    is.close(); 
	    return result;
	}
	
	/**
     * 将二进制转换成16进制
     * @method parseByte2HexStr
     * @param buf
     * @return
     * @throws 
     * @since v1.0
     */
    public static String parseByte2HexStr(byte buf[]){
        StringBuilder sb = new StringBuilder();
        for(int i = 0; i < buf.length; i++){
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }
    
    /**
     * 将16进制转换为二进制
     * @method parseHexStr2Byte
     * @param hexStr
     * @return
     * @throws 
     * @since v1.0
     */
    public static byte[] parseHexStr2Byte(String hexStr){
        if(hexStr.length() < 1)
            return null;
        byte[] result = new byte[hexStr.length()/2];
        for (int i = 0;i< hexStr.length()/2; i++) {
            int high = Integer.parseInt(hexStr.substring(i*2, i*2+1), 16);
            int low = Integer.parseInt(hexStr.substring(i*2+1, i*2+2), 16);
            result[i] = (byte) (high * 16 + low);
        }
        return result;
    }
    
    public static void main(String[] args) throws Exception {
    	String result = parseByte2HexStr(encrypt("aidaocao1&123456".getBytes(), Constants.KEY));
		System.out.println(result);
		System.out.println(new String(decrypt(parseHexStr2Byte(result), Constants.KEY)));
	}
	
}
