package com.bcxin.risk.common.util;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.google.common.base.CharMatcher;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.InputStream;
import java.net.*;
import java.util.*;

public class WebUtil {
	
	/** 当前绝对路径,供生成静态页面使用 */
	public static String currentPath = null;


    /**
     * 取得request中所有的参数名
     *
     * @param request
     * @return
     */
    @SuppressWarnings("unchecked")
    public static List<String> getRequestParamNames(HttpServletRequest request) {

        Enumeration<String> paramNameEnum = request.getParameterNames();
        List<String> result = new ArrayList<String>();

        //先将Enumeration中参数转成LIST
        while (paramNameEnum.hasMoreElements()) {
            result.add(paramNameEnum.nextElement().trim());
        }
        return result;
    }

    /**
     * 取得请求中的所有参数的键值对
     * add by chenmk 2009.12.25
     *
     * @param request
     * @return
     */
    public static Map<String, String> getParameterMap(HttpServletRequest request) {
        List<String> paramNameList = getRequestParamNames(request);

        Map<String, String> result = new HashMap<String, String>();

        if(paramNameList == null || paramNameList.size() == 0)
            return result;

        for(String paramName : paramNameList){
            result.put(paramName, request.getParameter(paramName));
        }


        return result;
    }


    /**
     * 取得请求中的所有参数的键值对
     * add by chenmk 2009.12.25
     *
     * @param request
     * @return
     */
    public static Map<String, String[]> getParameterValuesMap(HttpServletRequest request) {
        List<String> paramNameList = getRequestParamNames(request);

        Map<String, String[]> result = new HashMap<String, String[]>();

        if(paramNameList != null && paramNameList.size() > 0) {
            for(String paramName : paramNameList){
                result.put(paramName, request.getParameterValues(paramName));
            }
        }

        return result;
    }
    /**
     * 判断某个参数名称是否在request中
     *
     * @param request
     * @param paramName
     * @return
     */
    public static boolean hasParamName(HttpServletRequest request, String paramName) {

        if (StringUtil.isEmpty(paramName))
            return false;

        List<String> paramNameList = getRequestParamNames(request);

        return paramNameList.contains(paramName);
    }

    /**
     *   是否是当前的服务器URL
     * @param url
     * @param serverName
     * @param serverPort
     * @param contextPath
     * @return
     */
    private static boolean isCurrServerUrl(String url, String serverName, int serverPort, String contextPath) {
         if(url == null){
             return false;
         }
         if(serverPort != 80 && url.indexOf(":"+serverPort) == -1){
              return false;
         }
         if(!"/".equals(contextPath) && url.indexOf(contextPath) == -1){
             return false;
         }
         String currUrl = "";
         currUrl ="http://"+serverName;
         if(serverPort != 80){
             currUrl +=":"+serverPort;
         }
         if(!"/".equals(contextPath)){
             currUrl +=contextPath;
         }
         return url.indexOf(currUrl) > -1;
    }

    /**
     * 根据Cookie名称，获取Cookie。
     * add by wenjg 2009-11-25
     *
     * @param name
     * @return
     */
    public static Cookie getCookieByName(HttpServletRequest request, String name) {
    	Cookie[] cookies = request.getCookies();
        if(cookies != null){
            for (Cookie cookie : cookies) {
                if (cookie.getName().equals(name)){
                    return cookie;
                }
            }
        }
		return null;
    }


    /**
     * 增加一个cookie
     * add by wenjg 2009-11-25
     * @param cookie
     */
    public static void addCookie(HttpServletResponse response, Cookie cookie) {
    	response.addCookie(cookie);
    }

    /**
     * 根据Cookie名称和值添加默认设置的Cookie。
     * add by wenjg 2009-11-25
     * @param name
     * @param value
     */
    protected void addCookie(HttpServletResponse response,String name, String value) {
    	response.addCookie(new Cookie(name, value));
    }
    
    /**
	 * <b>Function</b> 获得当前Tomcat路径
	 * 
	 * @return
	 * @author ELLEX 2011-6-10 上午10:14:17
	 */
	public static String getCurrentPath() {
		if (currentPath == null) {
			try {
				File file = new File(Thread.currentThread().getContextClassLoader().getResource("").toURI());
				currentPath = file.getParentFile().getParent();
			} catch (URISyntaxException e) {

				currentPath = System.getProperty("user.dir");
				System.err.println("静态化页面输出路径为" + currentPath + ",获取路径信息出错: " + e.getMessage());
				return currentPath;
			}

		}
		return currentPath;
	}



    /** 获取客户端IP */
    public static final String getHost(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (StringUtils.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if ("127.0.0.1".equals(ip)) {
            InetAddress inet = null;
            try { // 根据网卡取本机配置的IP
                inet = InetAddress.getLocalHost();
            } catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ip = inet.getHostAddress();
        }
        // 对于通过多个代理的情况，第一个IP为客户端真实IP,多个IP按照','分割
        if (ip != null && ip.length() > 15) {
            if (ip.indexOf(",") > 0) {
                ip = ip.substring(0, ip.indexOf(","));
            }
        }
        return ip;
    }

    /**
     * 读取网页内容
     * @param str	网页地址，例：http://wwww.baidu.com
     * @return		网页内容
     * @throws java.io.IOException
     */
    public static String getHtmlCodeByURL(String str) throws java.io.IOException {
        URL url = new URL(str);
        HttpURLConnection urlConnection  = (HttpURLConnection)url.openConnection();
        InputStream in = urlConnection.getInputStream();
        byte[] data = new byte[in.available()];
        in.read(data);
        return new String(data);
    }


    public static String getHost(){
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        if(request!=null){
            return getHost(request);
        }
        return "";
    }

    /**
     * 读取ip
     * @param request
     * @return
     */
    public static String getIp1(HttpServletRequest request){
        String ip = request.getHeader("X-Forwarded-For");
        if(StringUtils.isNotEmpty(ip) && !"unKnown".equalsIgnoreCase(ip)){
            //多次反向代理后会有多个ip值，第一个ip才是真实ip
            int index = ip.indexOf(",");
            if(index != -1){
                return ip.substring(0,index);
            }else{
                return ip;
            }
        }
        ip = request.getHeader("X-Real-IP");
        if(StringUtils.isNotEmpty(ip) && !"unKnown".equalsIgnoreCase(ip)){
            return ip;
        }
        return request.getRemoteAddr();
    }

    /**
     * Map按key值重新排序
     * @param map
     * @return
     */
    public static SortedMap<String, String> mapSortByKey(Map<String, String> map) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        Object[] unSortKey = map.keySet().toArray();
        Arrays.sort(unSortKey);
        for (int i = 0; i < unSortKey.length; i++) {
            result.put(unSortKey[i].toString(), map.get(unSortKey[i]));
        }
        return result.tailMap(result.firstKey());
    }


    /**
     * Map按key值重新排序，且值转成排序
     * @param map
     * @return
     */
    public static SortedMap<String, Integer> getMapSortByKey(Map<String, String> map) {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        Object[] unSortKey = map.keySet().toArray();
        Arrays.sort(unSortKey);
        for (int i = 0; i < unSortKey.length; i++) {
            result.put(unSortKey[i].toString(), (i+1));
        }
        return result.tailMap(result.firstKey());
    }


    /**
     * Map按key值重新排序(根据实际情况 A11 A2 A1)，且排序转成值
     * @param map
     * @return
     */
    public static SortedMap<String, Integer> getMapSortByKeyInt(Map<String, String> map) {

        Map<Integer,String> m = new HashMap<Integer,String>();
        for(String key:map.keySet()){
             m.put(Integer.parseInt(CharMatcher.DIGIT.retainFrom(key)),key);
        }
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();

        Object[] unSortKey = m.keySet().toArray();
        Arrays.sort(unSortKey);
        for (int i = 0; i < unSortKey.length; i++) {
            result.put(m.get(unSortKey[i]), (i+1));
        }
        return result.tailMap(result.firstKey());
    }


    /**
     * 是否是Ajax异步请求
     */
    public static boolean isAjaxRequest(HttpServletRequest request){
        String accept = request.getHeader("accept");
        if (accept != null && accept.indexOf("application/json") != -1)
        {
            return true;
        }

        String xRequestedWith = request.getHeader("X-Requested-With");
        if (xRequestedWith != null && xRequestedWith.indexOf("XMLHttpRequest") != -1)
        {
            return true;
        }
        return false;
    }
}
