package com.bcxin.risk.common.util;

import cn.hutool.core.util.StrUtil;
import com.bcxin.risk.sys.resources.ConfigResources;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ConfigUtil {

	private static Map<String, String> data = new HashMap<String, String>();
	
	public static String getValue(String key) {
		String value = data.get(key.toUpperCase());

		//如果是获取 材料上传路径和临时路径
		if ( "materialupload_path".equalsIgnoreCase(key)
				|| "temp_path".equalsIgnoreCase(key) ) {
			//如果是开发环境，增加盘符
			String profileEnvi = ConfigResources.PROFILE_ENVI;
			if (Objects.equals(profileEnvi,"dev")) {
				if (value.startsWith("/")) {
					value = "D:" + value;
				}
			}
		}
		//如果是本地开发环境地址
		else if ( "web_url".equalsIgnoreCase(key) ) {
			String profileEnvi = ConfigResources.PROFILE_ENVI;
			if (Objects.equals(profileEnvi,"dev")) {
				value = "http://localhost:8080/";
			}
		}

		else if (key.endsWith("_platform")) {
			if (StrUtil.isEmpty(value)) {
				return "公安电子政务服务系统";
			}
		}

		return value;
	}

	public static String webSiteUrl(){
		return getValue("web_url");
	}

	/**
	 * 系统文件上传基础路径
	 */
	public static String material(){
		return getValue("materialUpload_path");
	}

	/**
	 * 系统文件上传临时路径
	 */
	public static String tempPath(){
		return getValue("temp_path");
	}
	
	public static void putValue(String key,String value) {
		data.put(key, value);
	}

	public static Map<String, String> getData() {
		return data;
	}
	
}
