package com.bcxin.risk.common.util;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 日期操作辅助类
 */
public final class BcxinDateUtil {
	private BcxinDateUtil() {
	}
	/** 日期格式 **/
    public interface DATE_PATTERN {
        String HHMMSS = "HHmmss";
        String HH_MM_SS = "HH:mm:ss";
        String YYYYMMDD = "yyyyMMdd";
        String YYYY_MM_DD = "yyyy-MM-dd";
        String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
        String YYYYMMDDHHMMSSSSS = "yyyyMMddHHmmssSSS";
        String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    }

	/**
	 * 格式化日期
	 * 
	 * @param date
	 * @param
	 * @return
	 */
	public static final String format(Object date) {
		return format(date, DATE_PATTERN.YYYY_MM_DD);
	}



	/**
	 * 校验日期格式（yyyy-MM-dd,yyyyMMdd,yyyy/MM/dd,yyyy.MM.dd）
	 *
	 * @param date
	 * @return
	 */
	public static boolean checkDate(String date) {
		String dateValue = marsalDate(date);
		return checkIsValidDateFormat(dateValue);
	}


	/**
	 * 当天的开始时间
	 * @return
	 */
	public static Date startOfTodDay() {
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		return calendar.getTime();
	}
	/**
	 * 当天的结束时间
	 * @return
	 */
	public static Date endOfTodDay() {
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 23);
		calendar.set(Calendar.MINUTE, 59);
		calendar.set(Calendar.SECOND, 59);
		calendar.set(Calendar.MILLISECOND, 999);
		return calendar.getTime();
	}


	public synchronized static String generatorRadomNumber() {
		Date today = new Date();
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
		return format.format(today) + new DecimalFormat("0000").format(new Random().nextInt(10000));
	}


	/**
	 * 转换中文格式的日期
	 * @param date
	 * @return
	 */
	public static String formatChinaDate(Date date){
		DateFormat df = new SimpleDateFormat("yyyy年MM月dd日 HH:mm");
		return df.format(date);
	}

	/**
	 * 计算两个时间的差值，并换算成中文
	 * @param beginDate
	 * @param endDate
	 * @return
	 */
	public static String diffFormatChina(Date beginDate,Date endDate) {
		long min = DateUtil.between(beginDate,endDate, DateUnit.MINUTE);
		long day = min/(24*60);
		long hour = (min-(day*(24*60)))/60;
		long mins = min - (day*(24*60) + hour*60);
		return day + "天" + hour + "小时" + mins + "分";
	}

	/**
	 * 格式化日期
	 *
	 * @param date
	 * @param pattern
	 * @return
	 */
	public static final String format(Object date, String pattern) {
		if (date == null) {
			return null;
		}
		if (pattern == null) {
			return format(date);
		}
		return new SimpleDateFormat(pattern).format(date);
	}

	/**
	 * 校验日期格式yyyy-MM-dd
	 *
	 * @param date
	 * @return
	 */
	public static boolean checkIsValidDateFormat(String date) {
		if (date == null) {
			return false;
		} else if (date.length() != 10) {
			return false;
		} else {
			String regex = "((\\d{2}(([02468][048])|([13579][26]))[\\-\\s]?((((0?[13578])|(1[02]))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\s]?((((0?[13578])|(1[02]))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";
			Pattern pattern = Pattern.compile(regex);
			Matcher mather = pattern.matcher(date);
			return mather.matches();
		}
	}


	/**
	 * 将year, month, day 组成日期格式（yyyy-MM-dd）字符串
	 *
	 * @param year
	 * @param month
	 * @param day
	 * @return date
	 */
	public static String marsalDate(String year, String month, String day) {
		String date;
		String yearTemp;
		String monthTemp;
		String dayTemp;

		if (year.length() != 4 || month.length() > 2 || day.length() > 2) {
			return null;
		}

		yearTemp = year;

		if (month.length() == 1) {
			monthTemp = "0" + month;
		} else {
			monthTemp = month;
		}

		if (day.length() == 1) {
			dayTemp = "0" + day;
		} else {
			dayTemp = day;
		}
		date = yearTemp + "-" + monthTemp + "-" + dayTemp;
		return date;
	}


	/**
	 * 将字符串（格式:yyyy-MM-dd,yyyyMMdd,yyyy/MM/dd,yyyy.MM.dd）转换成日期格式（yyyy-MM-dd）字符串
	 *
	 * @param date
	 * @return
	 */
	public static String marsalDate(String date) {
		date = date.replace("年", "-").replace("月", "-").replace("日", "");
		String split = "./-\t\\s";
		String dateTemp;
		String year;
		String month;
		String day;
		if (date.length() <= 10) {
			StringTokenizer tokenizer = new StringTokenizer(date, split);
			int tokenCount = tokenizer.countTokens();
			if (tokenCount == 3) {
				year = tokenizer.nextToken();
				month = tokenizer.nextToken();
				day = tokenizer.nextToken();
			} else if (tokenCount == 1) {
				dateTemp = tokenizer.nextToken();
				if (dateTemp.length() == 8) {
					year = dateTemp.substring(0, 4);
					month = dateTemp.substring(4, 6);
					day = dateTemp.substring(6, 8);
				} else if (dateTemp.length() == 6) {
					year = dateTemp.substring(0, 4);
					month = dateTemp.substring(4, 5);
					day = dateTemp.substring(5, 6);
				} else {
					return null;
				}
			} else {
				return null;
			}
			return marsalDate(year, month, day);
		} else {
			return null;
		}
	}

	/**
	 * input param formate like "2005-10-1"
	 *
	 * @return
	 * @throws ParseException
	 */
	public static int getLastDayOfMonth(String date) throws ParseException {
		DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		formatter.format(formatter.parse(date));
		Calendar c = formatter.getCalendar();
		int day = c.getActualMaximum(Calendar.DATE);
		return day;
	}

}
