package com.bcxin.risk.common.oss;

import java.io.File;
import java.io.InputStream;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;

public interface OSSService {

	public abstract OSSClient getClient();
	
	public String getServer();

	public abstract OSSResultInfo createDirectory(String directoryName);

	public abstract OSSResultInfo createDirectory(String directoryName,
			ObjectMetadata meta);

	public abstract boolean deleteDirectory(String directoryName);

	public abstract boolean deleteFile(String fileName);

	public abstract boolean isExitsDirectory(String directoryName);

	public abstract boolean isExitsFile(String file);

	public abstract OSSResultInfo put(String url, File file, boolean isCover);

	public abstract OSSResultInfo put(String url, File file,
			ObjectMetadata meta, boolean isCover);

	public abstract OSSResultInfo put(String url, InputStream input,
			ObjectMetadata meta);

	public abstract OSSResultInfo put(String url, InputStream input,
			boolean isCover);

	public abstract OSSResultInfo put(String url, InputStream input,
			ObjectMetadata meta, boolean isCover);

	public abstract File get(String url, String saveFileName);

	public abstract OSSResultObject get(String url);

	public abstract ObjectMetadata getFileMetadata(String url);

	public abstract String getBucketUrl();

	public abstract void copy(String srcPath, String desPath);

	public abstract void copy(String srcPath, String desPath,
			ObjectMetadata newMeta);

	public abstract void upMeta(String url, ObjectMetadata meta);

}