package com.bcxin.risk.activity;

import com.bcxin.risk.activity.dto.diff.ActivityDiffDTO;
import com.bcxin.risk.report.material.domain.MaterialFormModule;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author hzp
 * 活动帮助类
 */
public class ActivityUtil {

    /**
     * 1.对比活动基本信息差异
     * @param newInfo
     * @param oldInfo
     * @return 返回差异key值
     */
    public static List<ActivityDiffDTO> compareDiffActivity(Activity newInfo,Activity oldInfo) {
        List<ActivityDiffDTO> diffDTOList = new ArrayList<>();
        // 新增，所以数据库没有活动基本信息
        if (oldInfo == null) {
            return diffDTOList;
        }

        /* 得到类中的所有属性集合 */
        Field[] fs = newInfo.getClass().getDeclaredFields();
        for (int i = 0; i < fs.length; i++) {
            Field f = fs[i];
            String newVal = "";
            String oldVal = "";
            try {
                newVal = f.get(newInfo) != null ? f.get(newInfo).toString() : "";
                oldVal = f.get(oldInfo) != null ? f.get(oldInfo).toString() : "";
                // 新旧值不一样情况
                if (!Objects.equals(newVal, oldVal)) {
                    ActivityDiffDTO diffDTO = new ActivityDiffDTO();
                    diffDTO.setKey(f.getName());
                    diffDTO.setNewValue(newVal);
                    diffDTO.setOldValue(oldVal);
                    diffDTOList.add(diffDTO);
                }
            } catch (IllegalArgumentException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return diffDTOList;
    }

    /**
     * 2.对比活动主体现信息差异
     * @param list
     * @param map
     * @return 返回差异key值
     */
    public static List<ActivityDiffDTO> compareDiffModuleActivity(List<MaterialFormModule> list, Map<String,String> map) {
        List<ActivityDiffDTO> diffDTOList = new ArrayList<>();
        for(MaterialFormModule module : list){
            String moduleType=module.getMaterialModule();
            String oldValue=module.getValue();
            if(!Objects.equals(oldValue,map.get(moduleType))){
                ActivityDiffDTO diffDTO = new ActivityDiffDTO();
                diffDTO.setKey(moduleType);
                diffDTO.setNewValue(map.get(moduleType));
                diffDTO.setOldValue(oldValue);
                diffDTOList.add(diffDTO);
            }
        }
        return diffDTOList;
    }

    /**
     * 3.验证是否修改主体信息
     * @param list
     * @param map
     * @return
     */
    public static boolean validMaterialModuleChange(List<MaterialFormModule> list, Map<String,String> map){
        boolean changeFlag=false;
        // 第一次新增
        if(list==null || list.isEmpty()){
            return true;
        }
        for(MaterialFormModule module : list){
            String moduleType=module.getMaterialModule();
            String value=module.getValue();
            if(!Objects.equals(value,map.get(moduleType))){
                changeFlag=true;
                break;
            }
        }
        return changeFlag;
    }
}
