/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.sys;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.bcxin.risk.common.dao.MarketRegionDao;
import com.bcxin.risk.common.domain.MarketRegion;
import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.sys.SysRegionUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysMarketRegionUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysMarketRegionUtil.class);
    @Resource
    private SysRegionUtil sysRegionUtil;
    @Resource
    private MarketRegionDao marketRegionDao;
    private static List<MarketRegion> CACHE_KEY_MARKET_REGION_PROVINCE = Lists.newArrayList();
    private static List<MarketRegion> CACHE_KEY_MARKET_REGION_CITY = Lists.newArrayList();
    private static List<MarketRegion> CACHE_KEY_MARKET_REGION_INDEPENDENT = Lists.newArrayList();
    private static Map<String, MarketRegion> CACHE_KEY_BLAZER_MARKET_REGION = Maps.newHashMap();

    public List<MarketRegion> findRegionByLevel(String level) {
        if ("1".equals(level)) {
            if (CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_PROVINCE)) {
                return CACHE_KEY_MARKET_REGION_PROVINCE;
            }
        } else if ("2".equals(level) && CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_CITY)) {
            return CACHE_KEY_MARKET_REGION_CITY;
        }
        List rList = this.marketRegionDao.findRegionByLevel(level);
        if ("1".equals(level)) {
            CACHE_KEY_MARKET_REGION_PROVINCE = rList;
        } else if ("2".equals(level)) {
            CACHE_KEY_MARKET_REGION_CITY = rList;
        }
        return rList;
    }

    public List<MarketRegion> findRegionByIndependent() {
        if (CollectionUtil.isNotEmpty(CACHE_KEY_MARKET_REGION_INDEPENDENT)) {
            return CACHE_KEY_MARKET_REGION_INDEPENDENT;
        }
        Collection<MarketRegion> rList = this.findBlazerMarketList();
        CACHE_KEY_MARKET_REGION_INDEPENDENT = Lists.newArrayList(rList);
        return CACHE_KEY_MARKET_REGION_INDEPENDENT;
    }

    private Map<String, MarketRegion> findBlazerMarketRedis() {
        if (MapUtil.isNotEmpty(CACHE_KEY_BLAZER_MARKET_REGION)) {
            return CACHE_KEY_BLAZER_MARKET_REGION;
        }
        Collection<MarketRegion> rList = this.findBlazerMarketList();
        for (MarketRegion marketRegion : rList) {
            CACHE_KEY_BLAZER_MARKET_REGION.put(marketRegion.getOid() + "", marketRegion);
        }
        return CACHE_KEY_BLAZER_MARKET_REGION;
    }

    public Collection<MarketRegion> findBlazerMarketList() {
        return this.marketRegionDao.findBlazerMarket().values();
    }

    public MarketRegion getBlazerMarket(long regionCode) {
        Map<String, MarketRegion> marketRegionMap = this.findBlazerMarketRedis();
        MarketRegion obj = marketRegionMap.get(regionCode + "");
        if (obj == null) {
            return new MarketRegion();
        }
        return obj;
    }

    public boolean validBlazerMarket(long regionCode) {
        Map<String, MarketRegion> marketRegionMap = this.findBlazerMarketRedis();
        MarketRegion obj = marketRegionMap.get(regionCode + "");
        return obj != null;
    }

    public MarketRegion getBlazerMarketByCity(long cityCode) {
        Region region = this.sysRegionUtil.getRegionById(cityCode + "");
        Map<String, MarketRegion> marketRegionMap = this.findBlazerMarketRedis();
        MarketRegion obj = marketRegionMap.get(cityCode + "");
        if (obj == null) {
            if (this.isSpecialProvince(region.getParent_id(), cityCode + "")) {
                return obj;
            }
            return marketRegionMap.get(region.getParent_id() + "");
        }
        return obj;
    }

    public boolean validBlazerMarketByCity(long cityCode) {
        MarketRegion marketRegion = this.getBlazerMarketByCity(cityCode);
        return marketRegion != null;
    }

    public String getChannel(String cityRegionId) {
        MarketRegion marketRegion = this.getBlazerMarketByCity(Long.parseLong(cityRegionId));
        if (marketRegion != null) {
            return marketRegion.getWebsite();
        }
        return null;
    }

    public boolean isSpecialProvince(String provinceId, String cityId) {
        String[] specialCityList;
        for (String l : specialCityList = new String[]{""}) {
            if (!l.equals(provinceId)) continue;
            return true;
        }
        return false;
    }
}

