/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.log;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.activity.ActivityDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.domain.Dict;
import com.bcxin.risk.common.domain.MarketRegion;
import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.dynamic.DynamicPanelDao;
import com.bcxin.risk.dynamic.DynamicUtil;
import com.bcxin.risk.enums.BillCategoryEnum;
import com.bcxin.risk.enums.BillTypeEnum;
import com.bcxin.risk.log.ChangeLog;
import com.bcxin.risk.log.ChangeLogDao;
import com.bcxin.risk.report.material.dao.MaterialFormMenuDao;
import com.bcxin.risk.report.material.dao.MaterialFormMenuTemplateDao;
import com.bcxin.risk.report.material.domain.MaterialFormMenu;
import com.bcxin.risk.report.material.domain.MaterialFormMenuTemplate;
import com.bcxin.risk.sys.SysDictUtil;
import com.bcxin.risk.sys.SysMarketRegionUtil;
import com.bcxin.risk.sys.SysMaterialOptionUtil;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ChangeLogUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChangeLogUtil.class);
    @Autowired
    private ChangeLogDao changeLogDao;
    @Autowired
    private SysMaterialOptionUtil sysMaterialOptionUtil;
    @Autowired
    private SysMarketRegionUtil sysMarketRegionUtil;
    @Autowired
    private MaterialFormMenuDao materialFormMenuDao;
    @Autowired
    private ActivityDao activityDao;
    @Autowired
    private MaterialFormMenuTemplateDao materialFormMenuTemplateDao;
    @Autowired
    private DynamicUtil dynamicUtil;
    @Autowired
    private DynamicPanelDao dynamicPanelDao;
    @Autowired
    private SysDictUtil sysDictUtil;

    public void updateLogShowStatus(String activityNo, String showStatus) {
        Activity activity = this.activityDao.findActivityByActivityNo(activityNo);
        boolean flag = this.changeLogDao.checkLogUnShow(activityNo);
        if (flag) {
            this.dynamicUtil.saveDynamicActUpdateLog(activity.getOid());
        }
        this.changeLogDao.updateLogShowStatus(activityNo, showStatus);
    }

    @Async
    public void saveActChangeLog(MarketRegion marketRegion, String platform, String billId, String activityNo, Map<String, String> old, Map<String, String> now) {
        Long marketId = marketRegion != null ? marketRegion.getOid() : null;
        this.saveChangeLog(marketId, platform, billId, activityNo, BillCategoryEnum.ACTIVITY.getKey(), BillTypeEnum.ACTIVITY_INFO.getKey(), old, now);
    }

    @Async
    public void saveActModuleChangeLog(String activityNo, String platform, String changeContent) {
        Activity activity = this.activityDao.findActivityByActivityNo(activityNo);
        MarketRegion marketRegion = this.sysMarketRegionUtil.getBlazerMarketByCity(activity.getCity().getOid());
        Long marketRegionId = marketRegion != null ? marketRegion.getOid() : null;
        ChangeLog changeLog = new ChangeLog();
        changeLog.setBillId(activity.getOid() + "");
        changeLog.setActivityNo(activity.getActivityNo());
        changeLog.setBillCategory(BillCategoryEnum.ACTIVITY.getKey());
        changeLog.setBillType(BillTypeEnum.MATERIAL_MODULE_INFO.getKey());
        changeLog.setFlagId(activity.getOid() + "");
        changeLog.setMarkerRegionId(marketRegionId);
        changeLog.setSource(platform);
        changeLog.setSourceVal("\u4fee\u6539\u6750\u6599");
        changeLog.setNowVal("\u4fee\u6539\u6750\u6599");
        changeLog.setIsNew("1");
        changeLog.setIsUpdate("1");
        changeLog.setIsShow("0");
        changeLog.setChangeDate(new Date());
        changeLog.setText("\u6d3b\u52a8\u6750\u6599");
        changeLog.setRemark(changeContent);
        this.changeLogDao.saveChangeLog(changeLog);
    }

    @Async
    public void saveMaterialChangeLog(MarketRegion marketRegion, String platform, String billId, String activityNO, List<Map<String, Object>> oldMapList, List<Map<String, Object>> newMapList) {
        this.saveMaterialModuleLog(marketRegion, platform, billId, activityNO, oldMapList, newMapList);
    }

    public void saveMaterialMenuLog(MarketRegion marketRegion, String platform, String billId, String activityNO, String menuCode) {
        ArrayList<String> menuCodeList = new ArrayList<String>();
        menuCodeList.add(menuCode);
        List list = this.materialFormMenuTemplateDao.findByMenus(menuCodeList);
        String menuName = "";
        if (list != null && list.size() > 0) {
            menuName = ((MaterialFormMenuTemplate)list.get(0)).getMenuName();
        }
        Long marketRegionId = marketRegion != null ? marketRegion.getOid() : null;
        ChangeLog changeLog = new ChangeLog();
        changeLog.setText(menuName);
        changeLog.setNowVal("\u6750\u6599\u6709\u4fee\u6539");
        changeLog.setSourceVal("\u6750\u6599\u6709\u4fee\u6539");
        changeLog.setSource(platform);
        changeLog.setChangeDate(new Date());
        changeLog.setIsUpdate("1");
        changeLog.setIsNew("1");
        changeLog.setIsShow("0");
        changeLog.setMarkerRegionId(marketRegionId);
        changeLog.setActivityNo(activityNO);
        changeLog.setBillId(billId);
        changeLog.setFlagId(menuCode);
        changeLog.setBillType(BillTypeEnum.MATERIAL_INFO.getKey());
        changeLog.setBillCategory(BillCategoryEnum.ACTIVITY.getKey());
        this.changeLogDao.changeLogStatus("0", "1", billId, BillCategoryEnum.ACTIVITY.getKey(), BillTypeEnum.MATERIAL_INFO.getKey(), menuCode);
        this.changeLogDao.saveChangeLog(changeLog);
    }

    public void saveMaterialModuleLog(MarketRegion marketRegion, String platform, String billId, String activityNO, List<Map<String, Object>> oldMapList, List<Map<String, Object>> newMapList) {
        Map<String, String> tmpMap;
        Object attrCode;
        if (oldMapList == null || newMapList == null || oldMapList.isEmpty()) {
            return;
        }
        boolean isChange = false;
        boolean isAdd = false;
        boolean isDelete = false;
        String menuId = "";
        HashMap newMap = new HashMap();
        HashMap oldMap = new HashMap();
        ArrayList<String> listNew = new ArrayList<String>();
        ArrayList<String> listOld = new ArrayList<String>();
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Map<String, Object> tmp : newMapList) {
            attrCode = tmp.get("attrCode").toString();
            String newValue = tmp.get("value").toString();
            menuId = tmp.get("menuId").toString();
            tmpMap = new HashMap<String, String>();
            tmpMap.put("newVal", newValue);
            tmpMap.put("oldVal", newValue);
            map.put((String)attrCode, tmpMap);
            listNew.add((String)attrCode);
        }
        for (Map<String, Object> tmp : oldMapList) {
            attrCode = tmp.get("attrCode").toString();
            String oldValue = tmp.get("value").toString();
            if (map.containsKey(attrCode)) {
                tmpMap = (Map)map.get(attrCode);
                tmpMap.put("oldVal", oldValue);
            } else {
                tmpMap = new HashMap();
                tmpMap.put("newVal", "");
                tmpMap.put("oldVal", oldValue);
                map.put((String)attrCode, tmpMap);
            }
            listOld.add((String)attrCode);
        }
        String[] defaultAttrCode = new String[]{"A1", "B38", "B1", "B2", "B42", "D1", "D2"};
        List<String> defaultAttrCodeList = Arrays.asList(defaultAttrCode);
        for (String key : map.keySet()) {
            tmpMap = (Map)map.get(key);
            if (!Objects.equals(tmpMap.get("newVal"), tmpMap.get("oldVal"))) {
                isChange = true;
                break;
            }
            boolean isNeedCompare = true;
            for (String s : defaultAttrCodeList) {
                if (!key.startsWith(s)) continue;
                isNeedCompare = false;
            }
            if (!isNeedCompare) continue;
            if (listOld.contains(key) && !listNew.contains(key)) {
                isDelete = true;
                isChange = true;
                break;
            }
            if (listOld.contains(key) || !listNew.contains(key)) continue;
            isAdd = true;
            isChange = true;
            break;
        }
        if (isChange) {
            if (StringUtil.isEmpty((String)menuId)) {
                return;
            }
            MaterialFormMenu materialFormMenu = this.materialFormMenuDao.findMaterialFormMenuByOid(Long.valueOf(Long.parseLong(menuId)));
            Long marketRegionId = marketRegion != null ? marketRegion.getOid() : null;
            ChangeLog changeLog = new ChangeLog();
            changeLog.setText(materialFormMenu.getMenuName());
            changeLog.setNowVal("\u6750\u6599\u6709\u4fee\u6539");
            changeLog.setSourceVal("\u6750\u6599\u6709\u4fee\u6539");
            changeLog.setSource(platform);
            changeLog.setChangeDate(new Date());
            changeLog.setIsUpdate("1");
            changeLog.setIsNew("1");
            changeLog.setIsShow("0");
            changeLog.setMarkerRegionId(marketRegionId);
            changeLog.setActivityNo(activityNO);
            changeLog.setBillId(billId);
            changeLog.setFlagId(menuId);
            changeLog.setBillType(BillTypeEnum.MATERIAL_INFO.getKey());
            changeLog.setBillCategory(BillCategoryEnum.ACTIVITY.getKey());
            this.changeLogDao.changeLogStatus("0", "1", billId, BillCategoryEnum.ACTIVITY.getKey(), BillTypeEnum.MATERIAL_INFO.getKey(), menuId);
            this.changeLogDao.saveChangeLog(changeLog);
        }
    }

    public void saveMaterialModuleDetailLog(MarketRegion marketRegion, String platform, String billId, String activityNO, List<Map<String, Object>> oldMapList, List<Map<String, Object>> newMapList) {
        try {
            ChangeLog changeLog;
            Long marketRegionId;
            String value;
            String attrName;
            String optionType;
            String attrType;
            String attrCode;
            Map tmp;
            Map<String, Object> oldMap2;
            if (oldMapList == null || newMapList == null) {
                return;
            }
            ArrayList<ChangeLog> list = new ArrayList<ChangeLog>();
            String menuId = "";
            for (Map<String, Object> oldMap2 : oldMapList) {
                String attrCode2 = oldMap2.get("attrCode").toString();
                String attrType2 = oldMap2.get("attrType").toString();
                String optionType2 = oldMap2.containsKey("optionType") ? oldMap2.get("optionType").toString() : "";
                String attrName2 = oldMap2.get("attrName").toString();
                String value2 = oldMap2.get("value").toString();
                String newValue = "";
                menuId = oldMap2.get("menuId").toString();
                for (Map<String, Object> newMap : newMapList) {
                    String newAttrCode = newMap.get("attrCode").toString();
                    newValue = newMap.get("value").toString();
                    if (!attrCode2.equals(newAttrCode) || Objects.equals(value2, newValue)) continue;
                    String transferValue = this.setOptionValue(attrType2, optionType2, value2);
                    String transferNewValue = this.setOptionValue(attrType2, optionType2, newValue);
                    Long marketRegionId2 = marketRegion != null ? marketRegion.getOid() : null;
                    ChangeLog changeLog2 = new ChangeLog(marketRegionId2, platform, attrCode2, attrName2, (Object)transferValue, (Object)transferNewValue);
                    list.add(changeLog2);
                }
            }
            HashMap<String, Map<String, Object>> newMap = new HashMap<String, Map<String, Object>>();
            oldMap2 = new HashMap<String, Object>();
            for (Map<String, Object> tmp2 : newMapList) {
                String newAttrCode = tmp2.get("attrCode").toString();
                newMap.put(newAttrCode, tmp2);
            }
            for (Map<String, Object> tmp2 : oldMapList) {
                String oldAttrCode = tmp2.get("attrCode").toString();
                oldMap2.put(oldAttrCode, tmp2);
            }
            for (String key : newMap.keySet()) {
                if (oldMap2.containsKey(key)) continue;
                tmp = (Map)newMap.get(key);
                attrCode = tmp.get("attrCode").toString();
                attrType = tmp.get("attrType").toString();
                optionType = tmp.containsKey("optionType") ? tmp.get("optionType").toString() : "";
                attrName = tmp.get("attrName").toString();
                value = tmp.get("value").toString();
                String transferNewValue = this.setOptionValue(attrType, optionType, value);
                marketRegionId = marketRegion != null ? marketRegion.getOid() : null;
                changeLog = new ChangeLog(marketRegionId, platform, attrCode, attrName, (Object)"", (Object)transferNewValue);
                list.add(changeLog);
            }
            for (String key : oldMap2.keySet()) {
                if (newMap.containsKey(key)) continue;
                tmp = (Map)oldMap2.get(key);
                attrCode = tmp.get("attrCode").toString();
                attrType = tmp.get("attrType").toString();
                optionType = tmp.containsKey("optionType") ? tmp.get("optionType").toString() : "";
                attrName = tmp.get("attrName").toString();
                value = tmp.get("value").toString();
                String transferValue = this.setOptionValue(attrType, optionType, value);
                marketRegionId = marketRegion != null ? marketRegion.getOid() : null;
                changeLog = new ChangeLog(marketRegionId, platform, attrCode, attrName, (Object)transferValue, (Object)"");
                list.add(changeLog);
            }
            if (list != null && list.size() > 0) {
                for (ChangeLog changeLog3 : list) {
                    changeLog3.setBillId(billId);
                    changeLog3.setActivityNo(activityNO);
                    changeLog3.setBillCategory(BillCategoryEnum.ACTIVITY.getKey());
                    changeLog3.setBillType(BillTypeEnum.MATERIAL_INFO.getKey());
                    changeLog3.setFlagId(menuId);
                }
                this.changeLogDao.changeLogStatus("0", "1", billId, BillCategoryEnum.ACTIVITY.getKey(), BillTypeEnum.MATERIAL_INFO.getKey(), menuId);
                this.changeLogDao.insertBatch(list, 10);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Async
    public void saveChangeLog(Long marketRegionId, String platform, String billId, String activityNo, String billCategory, String billType, Map<String, String> old, Map<String, String> now) {
        try {
            if (old == null || now == null) {
                return;
            }
            ArrayList<ChangeLog> list = new ArrayList<ChangeLog>();
            for (String key : old.keySet()) {
                if (Objects.equals(old.get(key), now.get(key))) continue;
                String oldTransferVal = old.get(key);
                String newTransferVal = now.get(key);
                if (key.toUpperCase().equals("ACTIVITYTYPE")) {
                    oldTransferVal = this.setTypeValue("ACTIVITYTYPE", oldTransferVal);
                    newTransferVal = this.setTypeValue("ACTIVITYTYPE", newTransferVal);
                } else if (key.toUpperCase().equals("ADDRESSTYPE")) {
                    oldTransferVal = this.setTypeValue("ADDRESSTYPE", oldTransferVal);
                    newTransferVal = this.setTypeValue("ADDRESSTYPE", newTransferVal);
                }
                ChangeLog changeLog = new ChangeLog(marketRegionId, platform, key, (Object)oldTransferVal, (Object)newTransferVal);
                list.add(changeLog);
            }
            if (list != null && list.size() > 0) {
                for (ChangeLog changeLog : list) {
                    changeLog.setBillId(billId);
                    changeLog.setActivityNo(activityNo);
                    changeLog.setBillCategory(billCategory);
                    changeLog.setBillType(billType);
                    changeLog.setFlagId(billId);
                }
                this.changeLogDao.changeLogStatus("0", "1", billId, billCategory, billType, billId);
                this.changeLogDao.insertBatch(list, 10);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> getCompareMap(Activity activity) {
        Region province = activity.getProvince();
        Region city = activity.getCity();
        Region area = activity.getArea();
        Region unit = activity.getUnit();
        String actAddr = "";
        String provinceStr = province != null ? province.getProvince() : "";
        actAddr = actAddr + provinceStr;
        actAddr = actAddr + (city != null ? "-" + city.getCity() : "");
        actAddr = actAddr + (area != null ? "-" + area.getArea() : "");
        actAddr = actAddr + (unit != null ? "-" + unit.getArea() : "");
        HashMap map = Maps.newHashMap();
        map.put("activityName", activity.getName());
        map.put("activityType", activity.getActivityType());
        map.put("address", activity.getAddress());
        map.put("actAddr", actAddr);
        map.put("addressType", activity.getAddressType());
        map.put("number", activity.getNumber());
        map.put("activityDate", activity.getStartDate() + "~" + activity.getEndDate());
        map.put("sponsor", activity.getSponsor());
        return map;
    }

    private String setOptionValue(String attrType, String optionType, String value) {
        if ("checkbox".equals(attrType) || "select".equals(attrType) || "radio".equals(attrType)) {
            String[] options = value.split(",");
            String optionValue = "";
            for (String option : options) {
                optionValue = optionValue + this.sysMaterialOptionUtil.getOptionLabel(option, optionType, "") + ",";
            }
            if (optionValue.length() > 0) {
                optionValue = optionValue.substring(0, optionValue.length());
            }
            return optionValue;
        }
        return value;
    }

    private String setTypeValue(String type, String value) {
        if (StringUtil.isEmpty((String)value)) {
            return "";
        }
        Collection<Dict> list = this.sysDictUtil.getDictList(type);
        HashMap map = Maps.newHashMap();
        for (Dict dict : list) {
            map.put(dict.getValue(), dict.getLabel());
        }
        String[] tmp = value.split(",");
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = map.containsKey(tmp[i]) ? ((String)map.get(tmp[i])).toUpperCase() : tmp[i];
        }
        String newStr = "";
        for (String s : tmp) {
            newStr = newStr + s + ",";
        }
        if (StringUtil.isNotEmpty((String)newStr)) {
            newStr = newStr.substring(0, newStr.length() - 1);
        }
        return newStr;
    }
}

