/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.google.common.base.CharMatcher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebUtil {
    public static String currentPath = null;

    public static List<String> getRequestParamNames(HttpServletRequest request) {
        Enumeration paramNameEnum = request.getParameterNames();
        ArrayList<String> result = new ArrayList<String>();
        while (paramNameEnum.hasMoreElements()) {
            result.add(((String)paramNameEnum.nextElement()).trim());
        }
        return result;
    }

    public static Map<String, String> getParameterMap(HttpServletRequest request) {
        List<String> paramNameList = WebUtil.getRequestParamNames(request);
        HashMap<String, String> result = new HashMap<String, String>();
        if (paramNameList == null || paramNameList.size() == 0) {
            return result;
        }
        for (String paramName : paramNameList) {
            result.put(paramName, request.getParameter(paramName));
        }
        return result;
    }

    public static Map<String, String[]> getParameterValuesMap(HttpServletRequest request) {
        List<String> paramNameList = WebUtil.getRequestParamNames(request);
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        if (paramNameList != null && paramNameList.size() > 0) {
            for (String paramName : paramNameList) {
                result.put(paramName, request.getParameterValues(paramName));
            }
        }
        return result;
    }

    public static boolean hasParamName(HttpServletRequest request, String paramName) {
        if (StringUtil.isEmpty((String)paramName)) {
            return false;
        }
        List<String> paramNameList = WebUtil.getRequestParamNames(request);
        return paramNameList.contains(paramName);
    }

    private static boolean isCurrServerUrl(String url, String serverName, int serverPort, String contextPath) {
        if (url == null) {
            return false;
        }
        if (serverPort != 80 && url.indexOf(":" + serverPort) == -1) {
            return false;
        }
        if (!"/".equals(contextPath) && url.indexOf(contextPath) == -1) {
            return false;
        }
        String currUrl = "";
        currUrl = "http://" + serverName;
        if (serverPort != 80) {
            currUrl = currUrl + ":" + serverPort;
        }
        if (!"/".equals(contextPath)) {
            currUrl = currUrl + contextPath;
        }
        return url.indexOf(currUrl) > -1;
    }

    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static void addCookie(HttpServletResponse response, Cookie cookie) {
        response.addCookie(cookie);
    }

    protected void addCookie(HttpServletResponse response, String name, String value) {
        response.addCookie(new Cookie(name, value));
    }

    public static String getCurrentPath() {
        if (currentPath == null) {
            try {
                File file = new File(Thread.currentThread().getContextClassLoader().getResource("").toURI());
                currentPath = file.getParentFile().getParent();
            }
            catch (URISyntaxException e) {
                currentPath = System.getProperty("user.dir");
                System.err.println("\u9759\u6001\u5316\u9875\u9762\u8f93\u51fa\u8def\u5f84\u4e3a" + currentPath + ",\u83b7\u53d6\u8def\u5f84\u4fe1\u606f\u51fa\u9519: " + e.getMessage());
                return currentPath;
            }
        }
        return currentPath;
    }

    public static final String getHost(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (StringUtils.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if ("127.0.0.1".equals(ip)) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            ip = inet.getHostAddress();
        }
        if (ip != null && ip.length() > 15 && ip.indexOf(",") > 0) {
            ip = ip.substring(0, ip.indexOf(","));
        }
        return ip;
    }

    public static String getHtmlCodeByURL(String str) throws IOException {
        URL url = new URL(str);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        InputStream in = urlConnection.getInputStream();
        byte[] data = new byte[in.available()];
        in.read(data);
        return new String(data);
    }

    public static String getHost() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (request != null) {
            return WebUtil.getHost(request);
        }
        return "";
    }

    public static String getIp1(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotEmpty((CharSequence)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(",");
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (StringUtils.isNotEmpty((CharSequence)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static SortedMap<String, String> mapSortByKey(Map<String, String> map) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        Object[] unSortKey = map.keySet().toArray();
        Arrays.sort(unSortKey);
        for (int i = 0; i < unSortKey.length; ++i) {
            result.put(unSortKey[i].toString(), map.get(unSortKey[i]));
        }
        return result.tailMap((String)result.firstKey());
    }

    public static SortedMap<String, Integer> getMapSortByKey(Map<String, String> map) {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        Object[] unSortKey = map.keySet().toArray();
        Arrays.sort(unSortKey);
        for (int i = 0; i < unSortKey.length; ++i) {
            result.put(unSortKey[i].toString(), i + 1);
        }
        return result.tailMap((String)result.firstKey());
    }

    public static SortedMap<String, Integer> getMapSortByKeyInt(Map<String, String> map) {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        for (String key : map.keySet()) {
            m.put(Integer.parseInt(CharMatcher.DIGIT.retainFrom((CharSequence)key)), key);
        }
        TreeMap<Object, Integer> result = new TreeMap<Object, Integer>();
        Object[] unSortKey = m.keySet().toArray();
        Arrays.sort(unSortKey);
        for (int i = 0; i < unSortKey.length; ++i) {
            result.put(m.get(unSortKey[i]), i + 1);
        }
        return result.tailMap(result.firstKey());
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String accept = request.getHeader("accept");
        if (accept != null && accept.indexOf("application/json") != -1) {
            return true;
        }
        String xRequestedWith = request.getHeader("X-Requested-With");
        return xRequestedWith != null && xRequestedWith.indexOf("XMLHttpRequest") != -1;
    }
}

