/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.sys.SysBasicUtil;
import com.bcxin.risk.sys.resources.ConfigResources;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class EmailUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailUtil.class);
    private static final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";

    @Async
    public void sendEmail(String subject, String body, String to) {
        if (Objects.equals(ConfigResources.PROFILE_ENVI, "dev")) {
            return;
        }
        if (StringUtil.isEmpty((String)to)) {
            return;
        }
        if (!to.matches("[\\w\\.\\-]+@([\\w\\-]+\\.)+[\\w\\-]+")) {
            log.error("\u90ae\u7bb1\uff08" + to + "\uff09\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u683c\u5f0f\u4e0d\u5bf9!");
            return;
        }
        try {
            Properties props = System.getProperties();
            props.setProperty("mail.smtp.host", ConfigResources.MAIL_HOST);
            props.setProperty("mail.smtp.socketFactory.class", SSL_FACTORY);
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.port", "465");
            props.setProperty("mail.smtp.socketFactory.port", "465");
            props.put("mail.smtp.auth", "true");
            Authenticator a = new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(ConfigResources.MAIL_USERNAME, ConfigResources.MAIL_PASSWORD);
                }
            };
            Session session = Session.getDefaultInstance((Properties)props, (Authenticator)a);
            MimeMessage msg = new MimeMessage(session);
            String nick = "";
            try {
                nick = MimeUtility.encodeText((String)SysBasicUtil.getConfig("platform_name"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            msg.setFrom((Address)new InternetAddress(nick + " <" + ConfigResources.MAIL_FROM + ">"));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            msg.setSentDate(new Date());
            msg.setSubject(subject);
            msg.setText(body);
            Transport.send((Message)msg);
            log.debug("\u90ae\u4ef6\u53d1\u9001\u6210\u529f\uff0c\u6536\u4ef6\u4eba[{}]\uff0c\u4e3b\u9898[{}]\uff0c\u53d1\u9001\u5185\u5bb9[{}]", new Object[]{to, subject, body});
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u6536\u4ef6\u4eba[{}]\uff0c\u4e3b\u9898[{}]\uff0c\u53d1\u9001\u5185\u5bb9[{}]", new Object[]{to, subject, body});
            log.error("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u5f02\u5e38[{}]", (Object)e.getMessage());
        }
    }
}

