/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.enums;

import com.bcxin.risk.hibernateplus.exceptions.HibernatePlusException;
import com.bcxin.risk.hibernateplus.utils.StringUtils;

public enum Setting {
    MASTER("master", "\u4e3b\u6570\u636e\u5e93"),
    SLAVE("slave", "\u4ece\u6570\u636e\u5e93");

    private final String type;
    private final String desc;

    private Setting(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static Setting getSetting(String type) {
        if (StringUtils.isNotBlank(type)) {
            Setting[] dbTypes;
            for (Setting dbType : dbTypes = Setting.values()) {
                if (!dbType.getType().equalsIgnoreCase(type)) continue;
                return dbType;
            }
        }
        throw new HibernatePlusException("Error: Master-slave Setting error !");
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }
}

