/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.dao.impl;

import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.Convert;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.hibernateplus.utils.Assert;
import com.bcxin.risk.hibernateplus.utils.CollectionUtils;
import com.bcxin.risk.hibernateplus.utils.EntityInfoUtils;
import com.bcxin.risk.hibernateplus.utils.HibernateUtils;
import com.bcxin.risk.hibernateplus.utils.MapUtils;
import com.bcxin.risk.hibernateplus.utils.RandomUtils;
import com.bcxin.risk.hibernateplus.utils.ReflectionKit;
import com.bcxin.risk.hibernateplus.utils.SqlUtils;
import com.bcxin.risk.hibernateplus.utils.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class DaoImpl<P extends Convert>
implements IDao<P> {
    private static final Logger logger = Logger.getLogger(DaoImpl.class);
    @Autowired
    protected SessionFactory sessionFactory;

    protected Session getSession() {
        return HibernateUtils.getSession(this.masterSession(), this.isCurrent());
    }

    protected SessionFactory masterSession() {
        return EntityInfoUtils.getEntityInfo(this.poClass()).getMaster();
    }

    protected SessionFactory slaveSession() {
        Set<SessionFactory> slaves = EntityInfoUtils.getEntityInfo(this.poClass()).getSlaves();
        return CollectionUtils.isEmpty(slaves) ? this.masterSession() : RandomUtils.getRandomElement(slaves);
    }

    protected Class<P> poClass() {
        return ReflectionKit.getSuperClassGenricType(this.getClass(), 0);
    }

    protected Boolean isCurrent() {
        return true;
    }

    @Override
    public void evictObj(Object obj) {
        Session session = this.getSession();
        session.evict(obj);
    }

    @Override
    public void mergeObj(Object obj) {
        Session session = this.getSession();
        this.reflectSetCreateOn(obj);
        this.reflectSetUpdateOn(obj);
        session.merge(obj);
    }

    @Override
    public boolean insertBatch(List<P> list, int size) {
        try {
            Session e = HibernateUtils.getSession(this.masterSession(), this.isCurrent());
            for (int i = 0; i < list.size(); ++i) {
                e.save(list.get(i));
                if (i % size != 0) continue;
                e.flush();
                e.clear();
            }
            return true;
        }
        catch (Exception var5) {
            logger.warn((Object)("Warn: Unpected exception.  Cause:" + var5));
            return false;
        }
    }

    @Override
    public Criteria createCriteria(Class clazz) {
        return this.getSession().createCriteria(clazz);
    }

    @Override
    public <T> T selectById(Long oid) {
        return (T)this.getSession().get(this.poClass(), (Serializable)oid);
    }

    @Override
    public <T> T selectOne(Criterion criterion) {
        Criteria criteria = this.createCriteria(this.poClass());
        if (criterion != null) {
            criteria.add(criterion);
        }
        return (T)criteria.uniqueResult();
    }

    @Override
    public <T> T selectOne(List<Criterion> criterionList) {
        Criteria criteria = this.createCriteria(this.poClass());
        if (criterionList != null) {
            for (int i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        return (T)criteria.uniqueResult();
    }

    @Override
    public void save(Object obj) {
        this.reflectSetCreateOn(obj);
        this.getSession().save(obj);
    }

    @Override
    public void saveOrUpdate(Object obj) {
        try {
            Field[] fields = obj.getClass().getSuperclass().getDeclaredFields();
            boolean hasField = this.checkExistsOid(obj, fields);
            if (!hasField) {
                fields = obj.getClass().getSuperclass().getSuperclass().getDeclaredFields();
            }
            for (Field field : fields) {
                if (!field.getName().equals("oid")) continue;
                field.setAccessible(true);
                if (field.get(obj) != null) {
                    this.reflectSetUpdateOn(obj);
                } else {
                    this.reflectSetCreateOn(obj);
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getSession().saveOrUpdate(obj);
    }

    private boolean checkExistsOid(Object object, Field[] fields) throws IllegalAccessException {
        boolean hasField = false;
        for (Field field : fields) {
            if (!field.getName().equals("oid")) continue;
            field.setAccessible(true);
            hasField = true;
            break;
        }
        return hasField;
    }

    @Override
    public void update(Object obj) {
        this.reflectSetUpdateOn(obj);
        this.getSession().update(obj);
    }

    public int update(Wrapper wrapper) {
        String sqlUpdate = SqlUtils.sqlUpdate(this.poClass(), wrapper);
        return this.executeSqlUpdate(sqlUpdate);
    }

    @Override
    public void deleteObj(Object obj) {
        Session session = this.getSession();
        if (obj != null) {
            session.delete(obj);
        }
    }

    @Override
    public int delete(Serializable id) {
        String sqlDelete = SqlUtils.sqlDelete(this.poClass(), id);
        return this.executeSqlUpdate(sqlDelete);
    }

    @Override
    public int delete(Wrapper wrapper) {
        String sqlDelete = SqlUtils.sqlDelete(this.poClass(), wrapper);
        return this.executeSqlUpdate(sqlDelete);
    }

    @Override
    public boolean updateBatch(List<P> list, int size) {
        try {
            Session e = HibernateUtils.getSession(this.masterSession(), this.isCurrent());
            for (int i = 0; i < list.size(); ++i) {
                e.merge(list.get(i));
                if (i % size != 0) continue;
                e.flush();
                e.clear();
            }
            return true;
        }
        catch (Exception var5) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var5));
            return false;
        }
    }

    @Override
    public <T> List selectList() {
        Criteria criteria = this.createCriteria(this.poClass());
        return criteria.list();
    }

    @Override
    public <T> List selectList(Criterion criterion) {
        Criteria criteria = this.createCriteria(this.poClass());
        if (criterion != null) {
            criteria.add(criterion);
        }
        return criteria.list();
    }

    @Override
    public <T> List selectList(Criterion criterion, Order order) {
        Criteria criteria = this.createCriteria(this.poClass());
        if (criterion != null) {
            criteria.add(criterion);
        }
        if (order != null) {
            criteria.addOrder(order);
        }
        return criteria.list();
    }

    @Override
    public <T> List selectList(Order order) {
        Criteria criteria = this.createCriteria(this.poClass());
        if (order != null) {
            criteria.addOrder(order);
        }
        return criteria.list();
    }

    public <T> List selectList(Order[] orders) {
        Criteria criteria = this.createCriteria(this.poClass());
        if (orders != null) {
            for (int i = 0; i < orders.length; ++i) {
                criteria.addOrder(orders[i]);
            }
        }
        return criteria.list();
    }

    @Override
    public <T> List selectList(List<Criterion> criterionList) {
        Criteria criteria = this.createCriteria(this.poClass());
        if (criterionList != null) {
            for (int i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        return criteria.list();
    }

    @Override
    public <T> List selectList(List<Criterion> criterionList, Order order) {
        Criteria criteria = this.createCriteria(this.poClass());
        if (criterionList != null) {
            for (int i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        if (order != null) {
            criteria.addOrder(order);
        }
        return criteria.list();
    }

    public <T> List selectList(List<Criterion> criterionList, Order[] orders) {
        int i;
        Criteria criteria = this.createCriteria(this.poClass());
        if (criterionList != null) {
            for (i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        if (orders != null) {
            for (i = 0; i < orders.length; ++i) {
                criteria.addOrder(orders[i]);
            }
        }
        return criteria.list();
    }

    @Override
    public int selectCount() {
        int count = 0;
        try {
            String e = SqlUtils.sqlCount(this.poClass(), null);
            Query query = HibernateUtils.getSqlQuery(e, this.slaveSession(), this.isCurrent());
            BigInteger bigInteger = (BigInteger)query.uniqueResult();
            count = bigInteger.intValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    @Override
    public <T> List selectPage(Criterion criterion, Page page) {
        Criteria criteria = this.createCriteria(this.poClass());
        if (criterion != null) {
            criteria.add(criterion);
        }
        if (page != null) {
            int totalCount = ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
            page.setTotal(totalCount);
            criteria.setProjection(null);
            criteria.setFirstResult((page.getCurrent() - 1) * page.getSize()).setMaxResults(page.getSize());
        }
        return criteria.list();
    }

    @Override
    public <T> List selectPage(List<Criterion> criterionList, Page page) {
        Criteria criteria = this.createCriteria(this.poClass());
        if (criterionList != null) {
            for (int i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        if (page != null) {
            int totalCount = ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
            page.setTotal(totalCount);
            criteria.setProjection(null);
            criteria.setFirstResult((page.getCurrent() - 1) * page.getSize()).setMaxResults(page.getSize());
        }
        return criteria.list();
    }

    @Override
    public <T> List selectPage(List<Criterion> criterionList, Page page, Order order) {
        Criteria criteria = this.createCriteria(this.poClass());
        if (criterionList != null) {
            for (int i = 0; i < criterionList.size(); ++i) {
                criteria.add(criterionList.get(i));
            }
        }
        if (order != null) {
            criteria.addOrder(order);
        }
        if (page != null) {
            int totalCount = ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
            page.setTotal(totalCount);
            criteria.setProjection(null);
            criteria.setFirstResult((page.getCurrent() - 1) * page.getSize()).setMaxResults(page.getSize());
        }
        return criteria.list();
    }

    protected int executeSqlUpdate(String sql) {
        return this.executeSqlUpdate(sql, Collections.EMPTY_MAP);
    }

    protected int executeSqlUpdate(String sql, Object[] args) {
        Assert.hasLength(sql);
        int resultCount = 0;
        try {
            Query e = HibernateUtils.getSqlQuery(sql, this.masterSession(), this.isCurrent());
            if (null != args) {
                for (int i = 0; i < args.length; ++i) {
                    HibernateUtils.setParams(e, StringUtils.toString(i), args[i]);
                }
            }
            resultCount = e.executeUpdate();
        }
        catch (Exception var6) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var6));
        }
        return resultCount;
    }

    protected int executeSqlUpdate(String sql, Map<String, Object> params) {
        Assert.hasLength(sql);
        int resultCount = 0;
        if (StringUtils.isNotBlank(sql)) {
            try {
                Query e = HibernateUtils.getSqlQuery(sql, this.masterSession(), this.isCurrent());
                this.setParamMap(params, e);
                resultCount = e.executeUpdate();
            }
            catch (Exception var5) {
                logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var5));
            }
        }
        return resultCount;
    }

    protected int queryAggregate(String sql) {
        return this.queryAggregate(sql, SelectWrapper.DEFAULT);
    }

    protected int queryAggregate(String sql, Wrapper wrapper) {
        sql = sql + wrapper.getSqlSegment();
        int count = 0;
        try {
            Query e = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent());
            Object obj = e.uniqueResult();
            if (obj != null) {
                return Integer.parseInt(obj.toString());
            }
        }
        catch (Exception var6) {
            var6.printStackTrace();
        }
        return count;
    }

    @Override
    public Map<String, Object> queryMap(String sql, Wrapper wrapper) {
        Assert.hasLength(sql);
        Map map = Collections.emptyMap();
        try {
            sql = sql + wrapper.getSqlSegment();
            Query e = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            map = (Map)e.uniqueResult();
        }
        catch (Exception var5) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var5));
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> queryMaps(String sql, Wrapper wrapper) {
        List list = Collections.emptyList();
        try {
            sql = sql + wrapper.toString();
            Query e = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            list = e.list();
        }
        catch (Exception var5) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var5));
        }
        return list;
    }

    @Override
    public int querySqlCounts(String sql, Wrapper wrapper) {
        List list = Collections.emptyList();
        try {
            sql = sql + wrapper.toString();
            Query e = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            list = e.list();
        }
        catch (Exception var5) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var5));
        }
        return list.size();
    }

    public int querySqlCounts(String sql) {
        List list = Collections.emptyList();
        try {
            Query e = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            list = e.list();
        }
        catch (Exception var5) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var5));
        }
        return list.size();
    }

    protected Page<Map<String, Object>> queryMapsPage(String sql, Page page) {
        return this.queryMapsPage(sql, SelectWrapper.DEFAULT, page);
    }

    protected Page<Map<String, Object>> queryMapsPage(String sql, Wrapper wrapper, Page page) {
        Assert.hasLength(sql);
        try {
            sql = SqlUtils.sqlList(sql, wrapper, page);
            Query e = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            HibernateUtils.setPage(page.getCurrent(), page.getSize(), e);
            page.setRecords(e.list());
            this.setPageTotal(sql, page);
        }
        catch (Exception var5) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var5));
        }
        return page;
    }

    protected List<Map<String, Object>> queryMaps(String sql) {
        return this.queryMaps(sql, Collections.EMPTY_MAP);
    }

    protected List<Map<String, Object>> queryMaps(String sql, Map<String, Object> params) {
        Assert.hasLength(sql);
        List list = Collections.emptyList();
        try {
            Query e = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            this.setParamMap(params, e);
            list = e.list();
        }
        catch (Exception var5) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var5));
        }
        return list;
    }

    private void setPageTotal(String sql, Page<?> page) {
        if (page.isSearchCount()) {
            String sqlCount = SqlUtils.sqlCountOptimize(sql);
            Query countQuery = HibernateUtils.getSqlQuery(sqlCount, this.slaveSession(), this.isCurrent());
            BigInteger bigInteger = (BigInteger)countQuery.uniqueResult();
            page.setTotal(bigInteger.intValue());
        }
    }

    private void setParamMap(Map<String, Object> params, Query query) {
        if (MapUtils.isNotEmpty(params)) {
            for (String key : params.keySet()) {
                Object obj = params.get(key);
                HibernateUtils.setParams(query, key, obj);
            }
        }
    }

    @Override
    public <P> List<P> selectList(Wrapper wrapper) {
        List list = Collections.emptyList();
        try {
            String e = SqlUtils.sqlEntityList(this.poClass(), wrapper, null);
            Query query = HibernateUtils.getEntitySqlQuery(this.poClass(), e, this.slaveSession(), this.isCurrent());
            list = query.list();
        }
        catch (Exception var5) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var5));
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> selectMaps(Wrapper wrapper) {
        List list = Collections.emptyList();
        try {
            String e = SqlUtils.sqlList(this.poClass(), wrapper, (Page)null);
            Query query = HibernateUtils.getSqlQuery(e, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            list = query.list();
        }
        catch (Exception var5) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var5));
        }
        return list;
    }

    @Override
    public P selectOne(Wrapper wrapper) {
        List<P> list = this.selectList(wrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            int size = list.size();
            if (size > 1) {
                logger.warn((Object)String.format("Warn: selectOne Method There are  %s results.", size));
            }
            return (P)((Convert)list.get(0));
        }
        return null;
    }

    @Override
    public Page selectPage(Wrapper wrapper, Page page) {
        try {
            String e = SqlUtils.sqlEntityList(this.poClass(), wrapper, page);
            Query query = HibernateUtils.getEntitySqlQuery(this.poClass(), e, this.slaveSession(), this.isCurrent());
            HibernateUtils.setPage(page.getCurrent(), page.getSize(), query);
            page.setRecords(query.list());
            this.setPageTotal(e, page);
        }
        catch (Exception var5) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var5));
        }
        return page;
    }

    private void reflectSetCreateOn(Object object) {
        try {
            Field[] fields = object.getClass().getSuperclass().getDeclaredFields();
            boolean hasField = this.setCreateOn(object, fields);
            if (!hasField) {
                fields = object.getClass().getSuperclass().getSuperclass().getDeclaredFields();
                this.setCreateOn(object, fields);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean setCreateOn(Object object, Field[] fields) throws IllegalAccessException {
        boolean hasField = false;
        for (Field field : fields) {
            if (!field.getName().equals("createOn")) continue;
            field.setAccessible(true);
            if (field.getType() == Date.class) {
                field.set(object, new Date());
            }
            hasField = true;
            break;
        }
        return hasField;
    }

    private void reflectSetUpdateOn(Object object) {
        try {
            Field[] fields = object.getClass().getSuperclass().getDeclaredFields();
            boolean hasField = this.setUpdateOn(object, fields);
            if (!hasField) {
                fields = object.getClass().getSuperclass().getSuperclass().getDeclaredFields();
                this.setUpdateOn(object, fields);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean setUpdateOn(Object object, Field[] fields) throws IllegalAccessException {
        boolean hasField = false;
        for (Field field : fields) {
            if (!field.getName().equals("updateOn")) continue;
            hasField = true;
            field.setAccessible(true);
            if (field.getType() != Date.class) break;
            field.set(object, new Date());
            break;
        }
        return hasField;
    }

    public <T> List queryLists(String sql, Wrapper wrapper) {
        List list = Collections.emptyList();
        try {
            sql = sql + wrapper.toString();
            Query e = HibernateUtils.getSqlQuery(sql, this.slaveSession(), this.isCurrent()).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            list = e.list();
        }
        catch (Exception var5) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var5));
        }
        return list;
    }

    public <P> List<P> selectListBySql(String sql) {
        List list = Collections.emptyList();
        try {
            String e = sql;
            Query query = HibernateUtils.getEntitySqlQuery(this.poClass(), e, this.slaveSession(), this.isCurrent());
            list = query.list();
        }
        catch (Exception var5) {
            logger.warn((Object)("Warn: Unexpected exception.  Cause:" + var5));
        }
        return list;
    }
}

