package com.bcxin.oa.old.mapper.tempTask;

import com.bcxin.oa.old.common.CrudDao;
import com.bcxin.oa.old.dto.tempTask.ComTempTaskDto;
import com.bcxin.oa.old.dto.tempTask.ComTempTaskPerDto;
import com.bcxin.oa.old.entity.task.tempTask.ComTempTaskPer;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 临保任务人员mapper
 *
 * @author llc
 * @date 2020-03-11
 */
public interface ComTempTaskPerMapper extends CrudDao<ComTempTaskPer> {

    /**
     * 批量插入临保任务人员
     *
     * @param list
     * @author llc
     * @date 2020-03-11
     * @return
     */
    int insertTempTaskPerList(@Param("list") List<ComTempTaskPer> list);

    /**
     * 获取任务成员名单列表
     *
     * @param dto
     * @author llc
     * @date: 2020-03-11
     */
    List<Map<String, String>> getTaskPerList(ComTempTaskDto dto);


    /**
     * 查询本企业临保任务成员Id列表
     *
     * @param dto
     * @author llc
     * @date: 2020-03-11
     */
    List<String> getOwnTaskPerIdList(ComTempTaskPerDto dto);

    /**
     * 删除临保任务参人员
     *
     * @param perIdList
     * @param updateBy
     * @param comTempTaskId
     * @param comId
     * @param date
     * @author llc
     * @date: 2020-03-11
     */
    int deleteTaskPerByPerIdList(@Param("list") List<String> perIdList,
                                 @Param("updateBy") Long updateBy,
                                 @Param("comTempTaskId") Long comTempTaskId,
                                 @Param("comId") Long comId,
                                 @Param("date") String date);



    /**
     * 获取临保任务排班冲突人员列表
     *
     * @param comTempTaskId
     * @param perIdList
     * @author llc
     * @date 2020-03-11
     * @return
     */
    List<Map<String,String>> getConflictPerList(@Param("comTempTaskId") Long comTempTaskId,@Param("list") List<Long> perIdList);


    /**
     * 查询目前有效的临保任务人员列表
     *
     * @param comTempTaskId
     * @param perIdList
     * @author llc
     * @date 2020-03-11
     * @return
     */
    List<String> getTaskPerIdList(@Param("comTempTaskId") Long comTempTaskId,@Param("list") List<String> perIdList);



    /**
     * 更新临保任务参人员结束日期
     * @param comTempTaskId
     * @param updateBy
     * @param updateTime
     * @param date
     * @author llc
     * @date: 2020-03-16
     */
    int updateTaskPerEndDate(@Param("comTempTaskId") Long comTempTaskId,
                             @Param("updateBy") Long updateBy,
                             @Param("updateTime") Date updateTime,
                             @Param("date") String date);



    /**
     * 清除任务参与人员
     * @param comTempTaskId
     * @author llc
     * @date: 2020-03-18
     */
    int deleteTaskPer(@Param("comTempTaskId") Long comTempTaskId);

}