package com.bcxin.oa.old.mapper.app;

import com.bcxin.oa.old.dto.app.*;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * APP任务列表
 *
 * @author zhangye
 * @since 2018-02-26 10:23:07
 */
public interface AppComTaskMapper {

	/**
	 * 获取任务列表
	 * 
	 * @param appComTaskDTO
	 * @return
	 */
	List<AppComTaskDTO> pageTask(AppComTaskDTO appComTaskDTO);

	/**
	 * 获取任务列表
	 * 
	 * @param appComTaskDTO
	 * @return
	 */
	List<AppComTaskRoundDTO> getLastDayTaskRound(AppComTaskDTO appComTaskDTO);

	/**
	 * 返回任务详情
	 * 
	 * @param appComTaskDTO
	 * @return
	 */
	AppComTaskDetailsDTO getTaskDetails(AppComTaskDTO appComTaskDTO);

	/**
	 * 返回任务详情考勤列表
	 * 
	 * @param appComTaskDetailsDTO
	 * @return
	 */
	AppComTaskCalendarDTO getComTaskCalendar(AppComTaskDetailsDTO appComTaskDetailsDTO);

	/**
	 * 返回任务详情考勤班次列表
	 * 
	 * @param appComTaskCalendarDTO
	 * @return
	 */
	List<AppComTaskShiftDTO> getComTaskShiftList(AppComTaskCalendarDTO appComTaskCalendarDTO);

	/**
	 * 返回任务详情考勤轮次列表
	 * 
	 * @param appComTaskCalendarDTO
	 * @return
	 */
	List<AppComTaskSmallShiftDTO> getComTaskSmallShiftList(AppComTaskCalendarDTO appComTaskCalendarDTO);

	/**
	 * 返回任务详情负责人信息
	 * 
	 * @param appComTaskDetailsDTO
	 * @return
	 */
	AppComTaskInsidePushDTO getInChargePerson(AppComTaskDetailsDTO appComTaskDetailsDTO);

	/**
	 * 返回任务详情非负责人信息
	 * 
	 * @param appComTaskDetailsDTO
	 * @return
	 */
	List<AppComTaskInsidePushDTO> getNoChargePerson(AppComTaskDetailsDTO appComTaskDetailsDTO);

	/**
	 * 获取APP用户正在执行任务
	 * 
	 * @param appComTaskDTO
	 * @return
	 */
	AppComTaskSmallShiftDTO getRuningTaskRound(AppComTaskDTO appComTaskDTO);

	/**
	 * 根据用户ID、班次结束日期获取下一轮次信息
	 * 
	 * @param perId
	 * @param endWorkDate
	 * @return
	 */
	AppComTaskSmallShiftDTO getNextTaskRoundByEndWorkDate(@Param("perId") Long perId,
			@Param("endWorkDate") Date endWorkDate);

	/**
	 * 返回任务详情非负责人信息
	 * 
	 * @param appComTaskDTO
	 * @return
	 */
	List<AppComTaskInsidePushDTO> getTaskPerson(AppComTaskDTO appComTaskDTO);

	/**
	 * 班次执行情况查询
	 * 
	 * @param perId
	 * @param taskImplementId
	 * @return
	 */
	List<AppComTaskShiftDTO> getTaskShiftImplement(@Param("perId") Long perId,
			@Param("taskImplementId") Long taskImplementId);

	/**
	 * 返回任务状态
	 *
	 * @param appComTaskDTOParam
	 * @return
	 */
    AppComTaskDetailsDTO getTaskStatus(AppComTaskDTO appComTaskDTOParam);
}