package com.bcxin.oa.old.mapper;

import com.bcxin.oa.old.entity.task.ComTaskAttendAddress;
import com.bcxin.oa.old.common.CrudDao;

import java.util.List;

/**
 * 任务考勤地址
 *
 * @author zhangye
 * @since 2018-02-26 10:04:46
 */
public interface ComTaskAttendAddressMapper extends CrudDao<ComTaskAttendAddress> {

    /**
     * 删除之前的出勤地点
     *
     * @param comTaskId
     * @return
     */
    int deleteTaskAttendAddressById(Long comTaskId);

    /**
     * 删除之前的出勤地点通过taskAttendAddressId
     *
     * @param comTaskAttendAddress
     * @return
     */
    int deleteByTaskAttendAddressId(ComTaskAttendAddress comTaskAttendAddress);

    /**
     * 任务-出勤设置-出勤地点-列表
     *
     * @param comTaskId
     * @return
     */
    List<ComTaskAttendAddress> listComTaskAttendAddress(Long comTaskId);

    /**
     * 批量插入出勤地点
     *
     * @param listComTaskAttendAddress
     * @return
     */
    int batchInsertAttendAddress(List<ComTaskAttendAddress> listComTaskAttendAddress);
}