package com.bcxin.oa.old.entity.task;

import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.oa.old.common.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 任务内部推送
 * 
 * @author zhangye
 * @since 2018-02-26 10:42:16
 */
@Data
@TableName("com_task_inside_push")
public class ComTaskInsidePush extends BaseEntity<ComTaskInsidePush> {
	private static final long serialVersionUID = 247140767L;

	/** 内部推送ID */
	@ApiModelProperty(value = "内部推送ID")
	private Long insidePushId;

	/** 内部推送人员类别 */
	@ApiModelProperty(value = "内部推送人员类别")
	private String pushPerType;

	/** 任务ID */
	@ApiModelProperty(value = "任务ID")
	private Long comTaskId;

	/** 人员ID */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	/**
	 * 开始时间
	 */
	private Date startDate;

	/**
	 * 结束时间
	 */
	private Date endDate;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getInsidePushId() {
		return insidePushId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getComTaskId() {
		return comTaskId;
	}

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

}