package com.bcxin.oa.old.dto.bbd;


import com.bcxin.oa.old.entity.task.ComShiftRule;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;


/**
 * 任务班次同步
 *
 * @author llc
 * @date 2020-03-26
 */
@Data
public class BbdTaskShift{

    /** 班次ID */
    @ApiModelProperty(value = "班次ID")
    private Long shiftId;

    /** 班次名称 */
    @ApiModelProperty(value = "班次名称")
    private String shiftName;

    /** 班次类型 */
    @ApiModelProperty(value = "班次类型")
    private String shiftType;

    /** 生效规则 */
    @ApiModelProperty(value = "生效规则")
    private String effectRule;
    /** 班次规则详情 */
    @ApiModelProperty(value = "班次规则详情")
    private String shiftRuleDetail;

    /** 生效开始时间 */
    @ApiModelProperty(value = "生效开始时间")
    private Date effectStartTime;

    /** 生效截止时间 */
    @ApiModelProperty(value = "生效截止时间")
    private Date effectEndTime;

    /** 每天上下班次数 */
    @ApiModelProperty(value = "每天上下班次数")
    private Integer commutTimes;

    /** 允许迟到时间上限 */
    @ApiModelProperty(value = "允许迟到时间上限")
    private Integer permitLateUp;

    /** 严重迟到时间下限 */
    @ApiModelProperty(value = "严重迟到时间下限")
    private Integer seriousLateLow;

    /** 旷工时间下限 */
    @ApiModelProperty(value = "旷工时间下限")
    private Integer absentLow;

    /** 打卡时限上限 */
    @ApiModelProperty(value = "打卡时限上限")
    private Integer clockWorkLimit;

    /** 允许迟到校验开关 */
    @ApiModelProperty(value = "允许迟到校验开关")
    private String permitLateSwitch;

    /** 严重迟到校验开关 */
    @ApiModelProperty(value = "严重迟到校验开关")
    private String seriousLateSwitch;

    /** 旷工校验开关 */
    @ApiModelProperty(value = "旷工校验开关")
    private String absentSwitch;

    /** 打卡时限开关 */
    @ApiModelProperty(value = "打卡时限开关")
    private String clockLimitSwitch;

    private String sid;

    /**
     * 排班列表
     */
    private List<ComShiftRule> comShiftRuleList;


    /** 旧的班次ID */
    @ApiModelProperty(value ="旧的班次ID")
    private Long oldShiftId;

}
