package com.bcxin.oa.old.dto.bbd;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;


/**
 * 任务打卡同步
 *
 * @author llc
 * @date 2020-03-26
 */
@Data
public class BbdTaskCardRecord{

    /**
     * 任务打卡记录ID
     */
    @ApiModelProperty(value = "任务打卡记录ID")
    private Long taskCardRecordId;

    /**
     * 设置的打卡时间
     */
    @ApiModelProperty(value = "设置的打卡时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date setClockInTime;

    /**
     * 打卡日期
     */
    @ApiModelProperty(value = "打卡日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date clockInDate;

    /**
     * 打卡时间
     */
    @ApiModelProperty(value = "打卡时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date clockInTime;

    /**
     * 打卡类别(上班打卡、下班打卡)
     */
    @ApiModelProperty(value = "打卡类别(上班打卡、下班打卡)")
    private String clockInType;

    /**
     * 第几轮打卡
     */
    // @NotNull(message = "第几轮打卡不能为空")
    @ApiModelProperty(value = "第几轮打卡")
    private int clockInRound;

    /**
     * 打卡地点经度
     */
    @NotNull(message = "打卡地点经度不能为空")
    @ApiModelProperty(value = "打卡地点经度")
    private String placeLongitude;

    /**
     * 打卡地点纬度
     */
    @NotNull(message = "打卡地点纬度不能为空")
    @ApiModelProperty(value = "打卡地点纬度")
    private String palceLatitude;

    /**
     * 打卡方式(wifi打卡、地点打卡)
     */
    @NotNull(message = "打卡方式不能为空")
    @ApiModelProperty(value = "打卡方式(wifi打卡、地点打卡)")
    private String clockInWay;

    /**
     * 考勤状态
     */
    @ApiModelProperty(value = "考勤状态")
    private String attendStatus;

    /**
     * 班次ID
     */
    @ApiModelProperty(value = "班次ID")
    private Long shiftId;

    /**
     * 班次规则ID
     */
    @ApiModelProperty(value = "班次规则ID")
    private Long shiftRuleId;

    /**
     * 考勤WIFIID
     */
    @ApiModelProperty(value = "考勤WIFIID")
    private Long attendWifiId;

    /**
     * 打卡人员ID
     */
    @ApiModelProperty(value = "打卡人员ID")
    private Long perId;

    /**
     * 任务ID
     */
    @ApiModelProperty(value = "任务ID")
    private Long comTaskId;

    /**
     * 审批申请ID
     */
    @ApiModelProperty(value = "审批申请ID")
    private Long approveApplyId;

    /**
     * 打卡地点
     */
    @ApiModelProperty(value = "打卡地点")
    private String attendAddress;

    @ApiModelProperty(value = "创建者")
    private Long createBy;

    @ApiModelProperty(value = "创建日期")
    private Date createTime;

    @ApiModelProperty(value = "企业ID")
    protected Long comId; // 企业ID

    private String sid;


}
