package com.bcxin.oa.old.dto;


import com.bcxin.oa.old.entity.task.ComShift;
import com.bcxin.oa.old.entity.task.ComShiftRule;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 班次管理
 *
 * @author zhongjianhui
 * @version 1.0
 */
@Data
public class ComShiftDto extends ComShift {
    private static final long serialVersionUID = 4146577045010841004L;
    /**
     * 班次类型名
     */
    private String shiftTypeName;
    /**
     * [{  "startWorkTime":"09:00", "endWorkTime":"10:00","isStartNextDay":"0","isEndNextDay":"0"},{  "startWorkTime":"11:00", "endWorkTime":"03:00","isStartNextDay":"0","isEndNextDay":"1"}]
     * * 班次规则Json
     */
    /**
     * 上班时间
     */
    private String startWorkTime;
    /**
     * 下班时间
     */
    private String endWorkTime;
    /**
     * 轮次
    * */
    private String shiftRuleJson;
    /**
     * 班次规则list
     */
    private List<ComShiftRule> shiftRuleList;
    /**
     * 班次时间
     */
    private String shiftRuleTime;
    /**
     * 可以编辑
     */
    private Boolean canEdit;
    /**
     * 班次被使用信息
     */
    private String shiftMessage;
    /**
     * 生效规则今天
     */
    public static final String EFFECT_RULE_TODAY = "1";

    /**
     * 生效规则明天
     */
    public static final String EFFECT_RULE_TOMORROW = "2";

    /**
     * 表示false
     */
    public static final String COMM_FALSE = "0";

    /**
     * 表示true
     */
    public static final String COMM_TRUE = "1";


    /**
     * 是否值校验有效任务
     */
    private String isOnlyCheckEffect;

    /** 旧的班次ID */
    @ApiModelProperty(value = "旧的班次ID")
    private Long oldShiftId;


}
