package com.bcxin.oa.old.controller.system;

import com.bcxin.oa.old.aspect.Log;
import com.bcxin.oa.old.common.BaseController;
import com.bcxin.oa.old.common.Result;
import com.bcxin.oa.old.dto.ComBaseInfoDto;
import com.bcxin.oa.old.service.system.ComBaseInfoService;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * @author：wangcy @date：2017/12/20 0020 10:31
 * @description：PerAccountInfo的controller层
 */
@RestController
@RequestMapping("/system/com-base-info")
public class ComBaseInfoController extends BaseController {

	@Resource
	private ComBaseInfoService comBaseInfoService;


	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业管理", title = "企业详情", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping(value = "get")
	@ApiOperation(value = "企业管理", httpMethod = "GET", notes = "获取企业详情", response = ComBaseInfoDto.class)
	public Result get(ComBaseInfoDto comBaseInfoDto) {
		return comBaseInfoService.getByPrimaryKey(comBaseInfoDto).setBack(getRequest());
	}

	@PostMapping(value = "get-all-com")
	@ApiOperation(value = "获得所有的公司id", httpMethod = "POST", notes = "获得所有的公司id", response = ComBaseInfoDto.class)
	public Result getAllCom(@RequestParam String institutionType) {
		/* 【百课堂在调用，勿加权限校验】 */
		return comBaseInfoService.getAllComId(institutionType).setBack(getRequest());
	}

	@PostMapping(value = "get-info-by-comIds")
	@ApiOperation(value = "获得公司信息", httpMethod = "POST", notes = "获得公司信息", response = ComBaseInfoDto.class)
	public Result getInfoByComIds(@RequestParam String comIdList) {
		/* 【百课堂在调用，勿加权限校验】 */
		return comBaseInfoService.getInfoByComIdList(comIdList).setBack(getRequest());
	}

}
